/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;

public class ZipUtils {
    public static void unzip(File zipFile, String destDir) throws IOException {
        ZipUtils.unzip(zipFile, destDir, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, String destDir, int leadingPathSegmentsToTrim) throws IOException {
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String zipPath = ZipUtils.trimPathSegments(zipEntry.getName(), leadingPathSegmentsToTrim);
            File file = new File(destDir + "/" + zipPath);
            if (zipEntry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            InputStream is = null;
            FileOutputStream fos = null;
            try {
                is = zip.getInputStream(zipEntry);
                fos = new FileOutputStream(file);
                IOUtils.copy((InputStream)is, (OutputStream)fos);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    private static String trimPathSegments(String zipPath, int trimLeadingPathSegments) {
        int nextSlash;
        for (int i = 0; i < trimLeadingPathSegments && (nextSlash = zipPath.indexOf("/")) != -1; ++i) {
            zipPath = zipPath.substring(nextSlash);
        }
        return zipPath;
    }
}

