/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BambooProductHandler
extends AbstractWebappProductHandler {
    public BambooProductHandler(MavenProject project, MavenGoals goals) {
        super(project, goals, new BambooPluginProvider());
    }

    @Override
    public String getId() {
        return "bamboo";
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.bamboo", "atlassian-bamboo-web-app", "RELEASE");
    }

    protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
        return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-bamboo-plugin", salVersion));
    }

    @Override
    public ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact("com.atlassian.bamboo.plugins", "bamboo-plugin-test-resources", "LATEST");
    }

    @Override
    public int getDefaultHttpPort() {
        return 6990;
    }

    @Override
    public Map<String, String> getSystemProperties(Product ctx) {
        return Collections.singletonMap("bamboo.home", this.getHomeDirectory().getPath());
    }

    @Override
    public File getPluginsDirectory(String webappDir, File homeDir) {
        return new File(homeDir, "plugins");
    }

    @Override
    public List<ProductArtifact> getExtraContainerDependencies() {
        return Collections.emptyList();
    }

    @Override
    public String getBundledPluginPath() {
        return "WEB-INF/classes/atlassian-bundled-plugins.zip";
    }

    @Override
    public void processHomeDirectory(Product ctx, File homeDir) throws MojoExecutionException {
        ConfigFileUtils.replace(new File(homeDir, "bamboo.cfg.xml"), "@project-dir@", homeDir.getParent());
        ConfigFileUtils.replace(new File(homeDir, "bamboo.cfg.xml"), "/bamboo-home/", "/home/");
        ConfigFileUtils.replace(new File(homeDir, "bamboo.cfg.xml"), "${bambooHome}", homeDir.getAbsolutePath());
        ConfigFileUtils.replace(new File(homeDir, "/xml-data/configuration/administration.xml"), "http://192.168.15.145:8085", "http://" + ctx.getServer() + ":" + ctx.getHttpPort() + "/" + ctx.getContextPath().replaceAll("^/|/$", ""));
    }

    public List<ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptyList();
    }

    public List<ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BambooPluginProvider
    extends AbstractPluginProvider {
        private BambooPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-bamboo-plugin", salVersion));
        }
    }
}

