/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.product.BambooProductHandler;
import com.atlassian.maven.plugins.amps.product.ConfluenceProductHandler;
import com.atlassian.maven.plugins.amps.product.CrowdProductHandler;
import com.atlassian.maven.plugins.amps.product.FeCruProductHandler;
import com.atlassian.maven.plugins.amps.product.JiraProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.RefappProductHandler;
import java.util.Arrays;
import java.util.Collection;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductHandlerFactory {
    public static final String REFAPP = "refapp";
    public static final String CONFLUENCE = "confluence";
    public static final String JIRA = "jira";
    public static final String BAMBOO = "bamboo";
    public static final String FECRU = "fecru";
    public static final String CROWD = "crowd";

    public static ProductHandler create(String id, MavenProject project, MavenGoals goals, Log log) {
        if (REFAPP.equals(id)) {
            return new RefappProductHandler(project, goals);
        }
        if (CONFLUENCE.equals(id)) {
            return new ConfluenceProductHandler(project, goals);
        }
        if (JIRA.equals(id)) {
            return new JiraProductHandler(project, goals);
        }
        if (BAMBOO.equals(id)) {
            return new BambooProductHandler(project, goals);
        }
        if (FECRU.equals(id)) {
            return new FeCruProductHandler(project, goals, log);
        }
        if (CROWD.equals(id)) {
            return new CrowdProductHandler(project, goals);
        }
        throw new IllegalArgumentException("Unknown product id:" + id);
    }

    public static Collection<String> getIds() {
        return Arrays.asList(REFAPP, CONFLUENCE, JIRA, BAMBOO, FECRU, CROWD);
    }
}

