/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.core.util.FileUtils;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractProductHandler;
import com.atlassian.maven.plugins.amps.product.PluginProvider;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeCruProductHandler
extends AbstractProductHandler {
    private static final int STARTUP_CHECK_DELAY = 1000;
    private static final int STARTUP_CHECK_MAX = 180000;
    private final PluginProvider pluginProvider = new FeCruPluginProvider();
    private final Log log;

    public FeCruProductHandler(MavenProject project, MavenGoals goals, Log log) {
        super(project, goals);
        this.log = log;
    }

    @Override
    public String getId() {
        return "fecru";
    }

    @Override
    public int getDefaultHttpPort() {
        return 3990;
    }

    @Override
    public int start(Product ctx) throws MojoExecutionException {
        this.extractAndProcessHomeDirectory(ctx);
        this.addArtifacts(ctx);
        try {
            this.execFishEyeCmd("run");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting fisheye.", e);
        }
        this.waitForFishEyeToStart(ctx);
        return ctx.getHttpPort();
    }

    private void waitForFishEyeToStart(Product ctx) throws MojoExecutionException {
        boolean connected = false;
        int waited = 0;
        while (!connected) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                new Socket("localhost", ctx.getHttpPort()).close();
                connected = true;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (waited++ * 1000 <= 180000) continue;
            throw new MojoExecutionException("FishEye took longer than 180000ms to start!");
        }
    }

    @Override
    public void stop(Product ctx) throws MojoExecutionException {
        try {
            this.execFishEyeCmd("stop");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to stop FishEye/Crucible instance at " + ctx.getServer() + ":" + ctx.getHttpPort());
        }
    }

    private void execFishEyeCmd(String bootCommand) throws MojoExecutionException {
        try {
            URL fisheyebootUrl = new File(this.getHomeDirectory(), "fisheyeboot.jar").toURI().toURL();
            URLClassLoader cl = new URLClassLoader(new URL[]{fisheyebootUrl});
            Class<?> fisheyeCtl = cl.loadClass("com.cenqua.fisheye.FishEyeCtl");
            Method main = fisheyeCtl.getDeclaredMethod("mainImpl", String[].class);
            main.invoke(null, new Object[]{new String[]{bootCommand}});
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to execute fisheye command '" + bootCommand + "'", e);
        }
        this.log.info((CharSequence)"Started FishEye/Crucible.");
    }

    private File getBuildDirectory() {
        return new File(this.project.getBuild().getDirectory());
    }

    private void extractAndProcessHomeDirectory(Product ctx) throws MojoExecutionException {
        File homeDir = this.getHomeDirectory();
        File varDirectory = new File(homeDir, "var");
        if (!varDirectory.exists()) {
            File cruDistZip = this.goals.copyDist(this.getBuildDirectory(), new ProductArtifact("com.atlassian.crucible", "atlassian-crucible", ctx.getVersion()));
            File ampsDistZip = this.goals.copyHome(this.getBuildDirectory(), new ProductArtifact("com.atlassian.fecru", "amps-fecru", ctx.getProductDataVersion()));
            this.createDirectory(homeDir);
            try {
                ZipUtils.unzip(cruDistZip, homeDir.getPath(), 1);
                ZipUtils.unzip(ampsDistZip, homeDir.getPath());
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Unable to extract ZIP artifacts into home directory", (Exception)ex);
            }
            File configXml = new File(homeDir, "config.xml");
            ConfigFileUtils.replace(configXml, "@CONTROL_BIND@", String.valueOf(this.controlPort(ctx.getHttpPort())));
            ConfigFileUtils.replace(configXml, "@HTTP_BIND@", String.valueOf(ctx.getHttpPort()));
            ConfigFileUtils.replace(configXml, "@HTTP_CONTEXT@", String.valueOf(ctx.getContextPath()));
            ConfigFileUtils.replace(configXml, "@HOME_DIR@", String.valueOf(homeDir.getAbsolutePath()));
        } else {
            this.log.info((CharSequence)"Using existing FishEye/Crucible application and instance data.");
        }
    }

    private List<ProductArtifact> getPluginsArtifacts(Product ctx) {
        ArrayList<ProductArtifact> artifacts = new ArrayList<ProductArtifact>();
        artifacts.addAll(ctx.getPluginArtifacts());
        if (ctx.getSalVersion() != null) {
            artifacts.add(new ProductArtifact("com.atlassian.sal", "sal-api", ctx.getSalVersion()));
            artifacts.add(new ProductArtifact("com.atlassian.sal", "sal-fisheye-plugin", ctx.getSalVersion()));
        }
        if (ctx.getPdkVersion() != null) {
            artifacts.add(new ProductArtifact("com.atlassian.pdkinstall", "pdkinstall-plugin", ctx.getPdkVersion()));
        }
        if (ctx.getRestVersion() != null) {
            artifacts.add(new ProductArtifact("com.atlassian.plugins.rest", "atlassian-rest-module", ctx.getRestVersion()));
        }
        return artifacts;
    }

    private void createDirectory(File dir) throws MojoExecutionException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new MojoExecutionException("Failed to create directory " + dir.getAbsolutePath());
        }
    }

    private void addArtifacts(Product ctx) throws MojoExecutionException {
        try {
            File pluginsDir = new File(this.getHomeDirectory(), "var/plugins");
            this.createDirectory(pluginsDir);
            File bundledPluginsDir = new File(pluginsDir, "bundled");
            this.createDirectory(bundledPluginsDir);
            File userPluginsDir = new File(pluginsDir, "user");
            this.createDirectory(userPluginsDir);
            File bundledPluginsZip = new File(this.getHomeDirectory(), "plugins/bundled-plugins.zip");
            if (bundledPluginsZip.exists()) {
                ZipUtils.unzip(bundledPluginsZip, bundledPluginsDir.getPath());
            }
            if (this.isStaticPlugin()) {
                throw new MojoExecutionException("According to your atlassian-plugin.xml file, this plugin is not atlassian-plugins version 2. FishEye / Crucible currently only supports atlassian-plugins version 2.");
            }
            if (ctx.isInstallPlugin()) {
                this.addThisPluginToDirectory(userPluginsDir);
            }
            this.addArtifactsToDirectory(this.pluginProvider.provide(ctx), userPluginsDir);
            this.addArtifactsToDirectory(this.getPluginsArtifacts(ctx), userPluginsDir);
            ArrayList<ProductArtifact> artifacts = new ArrayList<ProductArtifact>();
            artifacts.addAll(ctx.getLibArtifacts());
            this.addArtifactsToDirectory(artifacts, new File(this.getHomeDirectory(), "lib"));
            artifacts = new ArrayList();
            artifacts.addAll(ctx.getBundledArtifacts());
            this.addArtifactsToDirectory(artifacts, bundledPluginsDir);
            if (bundledPluginsDir.list().length > 0) {
                FileUtils.createZipFile((File)bundledPluginsDir, (File)bundledPluginsZip);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to add plugin artifacts", e);
        }
    }

    private int controlPort(int httpPort) {
        return httpPort * 10 + 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FeCruPluginProvider
    extends AbstractPluginProvider {
        private FeCruPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-fisheye-plugin", salVersion));
        }
    }
}

