/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrowdProductHandler
extends AbstractWebappProductHandler {
    public CrowdProductHandler(MavenProject project, MavenGoals goals) {
        super(project, goals, new CrowdPluginProvider());
    }

    @Override
    public String getId() {
        return "crowd";
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.crowd", "crowd-web-app", "RELEASE");
    }

    @Override
    public ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact("com.atlassian.crowd.distribution", "crowd-plugin-test-resources", "LATEST");
    }

    @Override
    public int getDefaultHttpPort() {
        return 4990;
    }

    @Override
    public Map<String, String> getSystemProperties(final Product ctx) {
        return new HashMap<String, String>(){
            {
                this.put("crowd.home", CrowdProductHandler.this.getHomeDirectory().getPath());
                String contextPath = ctx.getContextPath();
                if (!contextPath.startsWith("/")) {
                    contextPath = "/" + contextPath;
                }
                if (!contextPath.endsWith("/")) {
                    contextPath = contextPath + "/";
                }
                this.put("crowd.property.crowd.server.url", "http://" + ctx.getServer() + ":" + ctx.getHttpPort() + contextPath + "services/");
            }
        };
    }

    @Override
    public File getPluginsDirectory(String webappDir, File homeDir) {
        return new File(homeDir, "plugins");
    }

    @Override
    public List<ProductArtifact> getExtraContainerDependencies() {
        return Arrays.asList(new ProductArtifact("hsqldb", "hsqldb", "1.8.0.7"), new ProductArtifact("jta", "jta", "1.0.1B"), new ProductArtifact("javax.mail", "mail", "1.4"), new ProductArtifact("javax.activation", "activation", "1.0.2"));
    }

    @Override
    public String getBundledPluginPath() {
        return "WEB-INF/classes/atlassian-bundled-plugins.zip";
    }

    @Override
    public void processHomeDirectory(Product ctx, File homeDir) throws MojoExecutionException {
        try {
            ConfigFileUtils.replaceAll(new File(homeDir, "crowd.cfg.xml"), "jdbc:hsqldb:.*/crowd-home/database/defaultdb", "jdbc:hsqldb:" + this.getHomeDirectory().getCanonicalPath() + "/database/defaultdb");
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    public List<ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptyList();
    }

    public List<ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CrowdPluginProvider
    extends AbstractPluginProvider {
        private CrowdPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-crowd-plugin", salVersion));
        }

        @Override
        protected Collection<ProductArtifact> getPdkInstallArtifacts(String pdkInstallVersion) {
            ArrayList<ProductArtifact> plugins = new ArrayList<ProductArtifact>();
            plugins.addAll(super.getPdkInstallArtifacts(pdkInstallVersion));
            plugins.add(new ProductArtifact("commons-fileupload", "commons-fileupload", "1.2.1"));
            return plugins;
        }
    }
}

