/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jfrog.maven.annomojo.annotations.MojoExecute;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;

@MojoGoal(value="run")
@MojoExecute(phase="package")
@MojoRequiresDependencyResolution
public class RunMojo
extends AbstractProductHandlerMojo {
    private static final char CONTROL_C = '\u001b';
    @MojoParameter(expression="${wait}", defaultValue="true")
    private boolean wait;
    @MojoParameter(expression="${amps.properties}", required=true, defaultValue="false")
    protected boolean writePropertiesToFile;
    protected final Map<String, String> properties = new HashMap<String, String>();

    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        MavenGoals goals = this.getMavenGoals();
        ProductHandler product = this.createProductHandler();
        Product ctx = this.getProductContexts(goals).get(0);
        ctx.setInstallPlugin(this.shouldInstallPlugin());
        int actualHttpPort = product.start(ctx);
        this.getLog().info((CharSequence)(product.getId() + " started successfully and available at http://localhost:" + actualHttpPort + ctx.getContextPath()));
        if (this.writePropertiesToFile) {
            this.properties.put("http.port", String.valueOf(actualHttpPort));
            this.properties.put("context.path", ctx.getContextPath());
            this.writePropertiesFile();
        }
        if (this.wait) {
            this.getLog().info((CharSequence)"Type CTRL-C to exit");
            try {
                while (System.in.read() != 27) {
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private boolean shouldInstallPlugin() {
        Artifact artifact = this.getMavenContext().getProject().getArtifact();
        return this.installPlugin && artifact != null && !"pom".equalsIgnoreCase(artifact.getType());
    }

    private void writePropertiesFile() throws MojoExecutionException {
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        File ampsProperties = new File(this.getMavenContext().getProject().getBuild().getDirectory(), "amps.properties");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(ampsProperties);
            props.store(out, "");
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing " + ampsProperties.getAbsolutePath(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }
}

