/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.RunMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jfrog.maven.annomojo.annotations.MojoExecute;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;

@MojoGoal(value="debug")
@MojoExecute(phase="package")
@MojoRequiresDependencyResolution
public class DebugMojo
extends RunMojo {
    @MojoParameter(expression="${jvm.debug.port}", defaultValue="5005")
    protected int jvmDebugPort;
    @MojoParameter(expression="${jvm.debug.suspend}")
    protected boolean jvmDebugSuspend = false;

    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.jvmArgs == null) {
            this.jvmArgs = "-Xmx512m -XX:MaxPermSize=160m";
        }
        this.jvmArgs = this.jvmArgs + " -Xdebug -Xrunjdwp:transport=dt_socket,address=" + String.valueOf(this.jvmDebugPort) + ",suspend=" + (this.jvmDebugSuspend ? "y" : "n") + ",server=y ";
        if (this.writePropertiesToFile) {
            this.properties.put("debug.port", String.valueOf(this.jvmDebugPort));
        }
        if (this.getDefaultProductId().equals("fecru") && this.debugNotSet()) {
            String message = "You must set the ATLAS_OPTS environment variable to the following string:'" + this.jvmArgs + "' when calling atlas-debug to enable Fisheye/Crucible debugging.";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
        super.doExecute();
    }

    private boolean debugNotSet() {
        String atlasOpts = System.getenv("ATLAS_OPTS");
        return atlasOpts == null || !atlasOpts.contains("-Xdebug");
    }
}

