/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractProductHandler;
import com.atlassian.maven.plugins.amps.product.PluginProvider;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.atlassian.maven.plugins.amps.util.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebappProductHandler
extends AbstractProductHandler {
    private final PluginProvider pluginProvider;

    public AbstractWebappProductHandler(MavenProject project, MavenGoals goals, PluginProvider pluginProvider) {
        super(project, goals);
        this.pluginProvider = pluginProvider;
    }

    @Override
    public int start(Product ctx) throws MojoExecutionException {
        File webappWar = this.goals.copyWebappWar(this.getId(), this.getBaseDirectory(), new ProductArtifact(this.getArtifact().getGroupId(), this.getArtifact().getArtifactId(), ctx.getVersion()));
        File homeDir = this.extractAndProcessHomeDirectory(ctx);
        File combinedWebappWar = this.addArtifacts(ctx, homeDir, webappWar);
        return this.goals.startWebapp(this.getId(), combinedWebappWar, this.getSystemProperties(ctx), this.getExtraContainerDependencies(), ctx);
    }

    @Override
    public void stop(Product ctx) throws MojoExecutionException {
        this.goals.stopWebapp(this.getId(), ctx.getContainerId());
    }

    private File addArtifacts(Product ctx, File homeDir, File webappWar) throws MojoExecutionException {
        try {
            String webappDir = new File(this.getBaseDirectory(), "webapp").getAbsolutePath();
            if (!new File(webappDir).exists()) {
                ZipUtils.unzip(webappWar, webappDir);
            }
            File pluginsDir = this.getPluginsDirectory(webappDir, homeDir);
            File bundledPluginsDir = new File(this.getBaseDirectory(), "bundled-plugins");
            bundledPluginsDir.mkdir();
            File bundledPluginsZip = new File(webappDir, this.getBundledPluginPath());
            if (bundledPluginsZip.exists()) {
                ZipUtils.unzip(bundledPluginsZip, bundledPluginsDir.getPath());
            }
            if (this.isStaticPlugin()) {
                pluginsDir = new File(webappDir, "WEB-INF/lib");
            }
            if (pluginsDir == null) {
                pluginsDir = bundledPluginsDir;
            }
            pluginsDir.mkdirs();
            if (ctx.isInstallPlugin()) {
                this.addThisPluginToDirectory(pluginsDir);
            }
            if (!this.isStaticPlugin()) {
                this.addArtifactsToDirectory(this.goals, this.pluginProvider.provide(ctx), pluginsDir);
            }
            ArrayList<ProductArtifact> artifacts = new ArrayList<ProductArtifact>();
            artifacts.addAll(this.getDefaultLibPlugins());
            artifacts.addAll(ctx.getLibArtifacts());
            this.addArtifactsToDirectory(this.goals, artifacts, new File(webappDir, "WEB-INF/lib"));
            artifacts = new ArrayList();
            artifacts.addAll(this.getDefaultBundledPlugins());
            artifacts.addAll(ctx.getBundledArtifacts());
            this.addArtifactsToDirectory(this.goals, artifacts, bundledPluginsDir);
            if (bundledPluginsDir.list().length > 0) {
                com.atlassian.core.util.FileUtils.createZipFile((File)bundledPluginsDir, (File)bundledPluginsZip);
            }
            if (ctx.getLog4jProperties() != null) {
                org.apache.commons.io.FileUtils.copyFile((File)ctx.getLog4jProperties(), (File)new File(webappDir, "WEB-INF/classes/log4j.properties"));
            }
            File warFile = new File(webappWar.getParentFile(), this.getId() + ".war");
            com.atlassian.core.util.FileUtils.createZipFile((File)new File(webappDir), (File)warFile);
            return warFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private File getBaseDirectory() {
        File dir = new File(this.project.getBuild().getDirectory(), this.getId());
        dir.mkdir();
        return dir;
    }

    private File extractAndProcessHomeDirectory(Product ctx) throws MojoExecutionException {
        if (this.getTestResourcesArtifact() != null) {
            File outputDir = this.getBaseDirectory();
            File homeDir = new File(outputDir, "home");
            if (!homeDir.exists()) {
                File confHomeZip = this.goals.copyHome(outputDir, new ProductArtifact(this.getTestResourcesArtifact().getGroupId(), this.getTestResourcesArtifact().getArtifactId(), ctx.getProductDataVersion()));
                File tmpDir = new File(this.getBaseDirectory(), "tmp-resources");
                tmpDir.mkdir();
                try {
                    ZipUtils.unzip(confHomeZip, tmpDir.getPath());
                    org.apache.commons.io.FileUtils.copyDirectory((File)tmpDir.listFiles()[0], (File)outputDir, (boolean)true);
                    File tmp = new File(outputDir, ctx.getId() + "-home");
                    boolean result = tmp.renameTo(homeDir);
                    if (!result) {
                        throw new IOException("Rename " + tmp.getPath() + " to " + homeDir.getPath() + " unsuccessful");
                    }
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Unable to copy home directory", (Exception)ex);
                }
                homeDir.mkdir();
                this.processHomeDirectory(ctx, homeDir);
            }
            try {
                this.overrideAndPatchHomeDir(homeDir, ctx.getId());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to override files using src/test/resources", (Exception)e);
            }
            return homeDir;
        }
        return this.getHomeDirectory();
    }

    private void overrideAndPatchHomeDir(File homeDir, String productId) throws IOException {
        File srcDir = new File(this.project.getBasedir(), "src/test/resources/" + productId + "-home");
        File outputDir = new File(this.getBaseDirectory(), "home");
        if (srcDir.exists() && outputDir.exists()) {
            org.apache.commons.io.FileUtils.copyDirectory((File)srcDir, (File)homeDir);
        }
    }

    private void addArtifactsToDirectory(MavenGoals goals, List<ProductArtifact> artifacts, File pluginsDir) throws MojoExecutionException {
        if (pluginsDir.isDirectory() && pluginsDir.exists()) {
            Iterator iterateFiles = org.apache.commons.io.FileUtils.iterateFiles((File)pluginsDir, null, (boolean)false);
            while (iterateFiles.hasNext()) {
                File file = (File)iterateFiles.next();
                for (ProductArtifact webappArtifact : artifacts) {
                    if (file.isDirectory() || !FileUtils.doesFileNameMatchArtifact(file.getName(), webappArtifact.getArtifactId())) continue;
                    file.delete();
                }
            }
        }
        if (!artifacts.isEmpty()) {
            goals.copyPlugins(pluginsDir, artifacts);
        }
    }

    protected abstract void processHomeDirectory(Product var1, File var2) throws MojoExecutionException;

    protected abstract ProductArtifact getTestResourcesArtifact();

    protected abstract Collection<ProductArtifact> getDefaultBundledPlugins();

    protected abstract Collection<ProductArtifact> getDefaultLibPlugins();

    protected abstract String getBundledPluginPath();

    protected abstract File getPluginsDirectory(String var1, File var2);

    protected abstract List<ProductArtifact> getExtraContainerDependencies();

    protected abstract Map<String, String> getSystemProperties(Product var1);

    protected abstract ProductArtifact getArtifact();
}

