/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProductHandler
implements ProductHandler {
    protected final MavenGoals goals;
    protected final MavenProject project;

    protected AbstractProductHandler(MavenProject project, MavenGoals goals) {
        this.project = project;
        this.goals = goals;
    }

    protected boolean isStaticPlugin() throws IOException {
        File atlassianPluginXml = new File(this.project.getBasedir(), "src/main/resources/atlassian-plugin.xml");
        if (atlassianPluginXml.exists()) {
            String text = org.apache.commons.io.FileUtils.readFileToString((File)atlassianPluginXml);
            return !text.contains("pluginsVersion=\"2\"") && !text.contains("plugins-version=\"2\"");
        }
        return false;
    }

    protected void addThisPluginToDirectory(File targetDir) throws IOException {
        File thisPlugin = this.getPluginFile();
        Iterator iterateFiles = org.apache.commons.io.FileUtils.iterateFiles((File)targetDir, null, (boolean)false);
        while (iterateFiles.hasNext()) {
            File file = (File)iterateFiles.next();
            if (!FileUtils.doesFileNameMatchArtifact(file.getName(), this.project.getArtifactId())) continue;
            file.delete();
        }
        org.apache.commons.io.FileUtils.copyFile((File)thisPlugin, (File)new File(targetDir, thisPlugin.getName()));
    }

    protected File getPluginFile() {
        return new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".jar");
    }

    protected void addArtifactsToDirectory(List<ProductArtifact> artifacts, File pluginsDir) throws MojoExecutionException {
        if (pluginsDir.isDirectory() && pluginsDir.exists()) {
            Iterator iterateFiles = org.apache.commons.io.FileUtils.iterateFiles((File)pluginsDir, null, (boolean)false);
            while (iterateFiles.hasNext()) {
                File file = (File)iterateFiles.next();
                for (ProductArtifact webappArtifact : artifacts) {
                    if (file.isDirectory() || !FileUtils.doesFileNameMatchArtifact(file.getName(), webappArtifact.getArtifactId())) continue;
                    file.delete();
                }
            }
        }
        if (!artifacts.isEmpty()) {
            this.goals.copyPlugins(pluginsDir, artifacts);
        }
    }

    protected File getHomeDirectory() {
        File homeDir = new File(new File(this.project.getBuild().getDirectory(), this.getId()), "home");
        if (!homeDir.exists()) {
            homeDir.mkdirs();
        }
        return homeDir;
    }
}

