/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.pdk;

import com.atlassian.core.util.FileUtils;
import com.atlassian.maven.plugins.pdk.BasePdkMojo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class GenerateWarMojo
extends BasePdkMojo {
    private MavenProject project;
    private String tempBaseDir;
    private String overwrite;
    private String warInstallPath;
    private String warFileName;
    private static final String ATLASSIAN = "exploded";
    private static final String WEB_INF = "WEB-INF";
    private static final String LIB = "lib";

    public void execute() throws MojoExecutionException, MojoFailureException {
        LinkedList dependencies = this.findDependencies(this.project, "war");
        if (dependencies.size() > 0) {
            Dependency dependency = (Dependency)dependencies.getFirst();
            File src = this.getDependencyAsFile(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType());
            File warTempPath = new File(this.tempBaseDir + File.separator + dependency.getArtifactId() + File.separator + dependency.getVersion());
            if (this.warFileName == null) {
                this.warFileName = dependency.getArtifactId() + "-" + dependency.getVersion() + ".war";
            }
            this.getLog().info((CharSequence)("Path to the Atlassian WAR is = " + this.warInstallPath));
            if (this.overwrite.equals("true")) {
                // empty if block
            }
            if (!new File(warTempPath, this.warFileName).exists() || this.overwrite.equals("true")) {
                if (src.exists()) {
                    this.getLog().info((CharSequence)"Preparing Atlassian WAR");
                    this.unJarFiles(src, warTempPath);
                    this.installFunctestRPC(warTempPath);
                    this.createConfluenceWAR(warTempPath);
                } else {
                    this.getLog().warn((CharSequence)"An Atlassian WAR not specified as a dependency. The Atlasian Test WAR cannot be created.");
                }
            } else {
                this.getLog().info((CharSequence)"The Atlassian Test WAR has already been built.");
            }
        } else {
            this.getLog().warn((CharSequence)"Dependency not found... Skipped Downloading Atlassian WAR.");
            this.getLog().warn((CharSequence)"Please add a dependency of the form: \n<dependency>\n    <groupId>com.atlassian.something</groupId>\n    <artifactId>something-webapp</artifactId>\n    <version>[version number]</version>\n    <type>war</type>\n    <scope>provided</scope>\n</dependency>");
        }
    }

    private Dependency findDependency(MavenProject project, String groupId, String artifactId) {
        for (Dependency a : project.getDependencies()) {
            if (!a.getGroupId().equals(groupId) || !a.getArtifactId().equals(artifactId)) continue;
            return a;
        }
        return null;
    }

    private LinkedList findDependencies(MavenProject project, String type) {
        LinkedList<Dependency> dependencies = new LinkedList<Dependency>();
        for (Dependency a : project.getDependencies()) {
            if (!a.getType().equals(type)) continue;
            dependencies.add(a);
        }
        return dependencies;
    }

    private void createConfluenceWAR(File explodedWar) {
        File target = new File(this.warInstallPath, this.warFileName);
        String zipDirPath = ATLASSIAN;
        this.getLog().info((CharSequence)"Creating Atlassian WAR ");
        try {
            FileUtils.createZipFile((File)new File(explodedWar, zipDirPath), (File)target);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    private void installFunctestRPC(File installDir) {
        String groupId = "com.atlassian.confluence.extra";
        String artifactId = "functestrpc";
        Dependency dependency = this.findDependency(this.project, groupId, artifactId);
        if (dependency != null) {
            File dest = new File(installDir, ATLASSIAN + File.separator + WEB_INF + File.separator + LIB);
            this.getLog().info((CharSequence)"Installing functestrpc");
            this.copyFiles(this.getDependencyAsFile(groupId, artifactId, dependency.getVersion(), dependency.getType()), dest);
        }
    }

    private static boolean deleteDir(File dir) {
        File candir;
        if (dir == null) {
            return false;
        }
        try {
            candir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (!candir.equals(dir.getAbsoluteFile())) {
            return false;
        }
        File[] files = candir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                boolean deleted;
                File file = files[i];
                boolean bl = deleted = !file.delete();
                if (!deleted || !file.isDirectory()) continue;
                GenerateWarMojo.deleteDir(file);
            }
        }
        return dir.delete();
    }

    private void unJarFiles(File source, File target) {
        try {
            int BUFFER = 2048;
            String fileName = ATLASSIAN;
            target = new File(target, fileName);
            GenerateWarMojo.deleteDir(target);
            target.mkdirs();
            ZipFile jarfile = new ZipFile(source);
            Enumeration<? extends ZipEntry> e = jarfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (!entry.isDirectory()) {
                    int count;
                    BufferedInputStream is = new BufferedInputStream(jarfile.getInputStream(entry));
                    byte[] data = new byte[2048];
                    FileOutputStream fos = new FileOutputStream(new File(target, entry.getName()));
                    BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                    while ((count = is.read(data, 0, 2048)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                    dest.close();
                    is.close();
                    continue;
                }
                File file = new File(target, entry.getName());
                file.mkdirs();
            }
            jarfile.close();
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }

    protected File getDependencyAsFile(String groupId, String artifactId, String version, String type) {
        String archetypeArtifactPath = this.localRepository.getBasedir() + "/" + this.localRepository.pathOf(this.getArtifact(groupId, artifactId, version, type));
        return new File(archetypeArtifactPath);
    }

    public void setTempBaseDir(String tempBaseDir) {
        this.tempBaseDir = tempBaseDir;
    }

    public void setDependencies(ArrayList dependencies) {
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getWarInstallPath() {
        return this.warInstallPath;
    }

    public void setWarInstallPath(String warInstallPath) {
        this.warInstallPath = warInstallPath;
    }

    public String getWarFileName() {
        return this.warFileName;
    }

    public void setWarFileName(String warFileName) {
        this.warFileName = warFileName;
    }

    public void setOverwrite(String overwrite) {
        this.overwrite = overwrite;
    }
}

