/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.pdk;

import com.atlassian.maven.plugins.pdk.BasePluginServerMojo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class UninstallPluginMojo
extends BasePluginServerMojo {
    private static final String UPLOAD = "upload";
    private static final String COPY = "copy";
    protected String installMethod = "upload";
    protected File pluginsHome;
    protected String artifactId;

    protected String getTitle() {
        return "Uninstall Plugin";
    }

    protected void init(String user, String pass, String confUrl, String pluginKey, String installMethod, File pluginsHome) {
        this.username = user;
        this.password = pass;
        this.serverUrl = confUrl;
        this.pluginKey = pluginKey;
        this.installMethod = installMethod;
        this.pluginsHome = pluginsHome;
    }

    protected boolean checkProperties() {
        if (this.installMethod == null || !UPLOAD.equalsIgnoreCase(this.installMethod) && !COPY.equalsIgnoreCase(this.installMethod)) {
            this.getLog().error((CharSequence)"Please specify either 'upload' or 'copy' for the 'atlassian.pdk.install.method' property.");
            return true;
        }
        if (COPY.equals(this.installMethod) && this.pluginsHome == null) {
            this.getLog().error((CharSequence)"Please specify the 'atlassian.pdk.server.home' property.");
            return true;
        }
        return super.checkProperties();
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        if (this.checkProperties()) {
            return;
        }
        if (COPY.equals(this.installMethod)) {
            this.deleteFiles(this.artifactId, this.pluginsHome);
        } else if (UPLOAD.equals(this.installMethod)) {
            super.execute();
        }
    }

    private void deleteFiles(final String artifactId, File pluginsHome) {
        File[] files = pluginsHome.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(artifactId + "-") && name.endsWith(".jar");
            }
        });
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].exists() && this.checkPluginKey(files[i]) && files[i].delete()) {
                    this.getLog().info((CharSequence)(this.getTitle() + ": Deleted previous version of plugin: " + files[i].getName()));
                    continue;
                }
                this.getLog().info((CharSequence)(this.getTitle() + ": Did not delete existing jar file: " + files[i].getName()));
            }
        } else {
            this.getLog().info((CharSequence)(this.getTitle() + ": No previous versions of plugin were found."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPluginKey(File file) {
        BufferedReader in = null;
        try {
            JarFile jar = new JarFile(file);
            JarEntry apx = jar.getJarEntry("atlassian-plugin.xml");
            if (apx != null) {
                boolean matches;
                in = new BufferedReader(new InputStreamReader(jar.getInputStream(apx)));
                String line = null;
                while ((line = in.readLine()) != null && line.indexOf(this.pluginKey) < 0) {
                }
                boolean bl = matches = line != null;
                if (!matches) {
                    this.getLog().info((CharSequence)(this.getTitle() + ": The plugin specified does not match the required plugin key: " + this.pluginKey));
                }
                boolean bl2 = matches;
                return bl2;
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)(this.getTitle() + ": Unable to read jar file: " + file.getName()), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)(this.getTitle() + ": Error while closing the atlassian-plugin.xml stream"), (Throwable)e);
                }
            }
        }
        return false;
    }

    protected String getMode() {
        return "uninstall";
    }
}

