/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.pdk;

import com.atlassian.maven.plugins.pdk.BasePdkMojo;
import java.io.IOException;
import java.net.ConnectException;
import org.apache.commons.httpclient.DefaultMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MethodRetryHandler;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class BasePluginServerMojo
extends BasePdkMojo {
    protected String username;
    protected String password;
    protected String serverUrl;
    protected String pluginKey;

    protected void init(String user, String pass, String confUrl, String pluginKey) {
        this.username = user;
        this.password = pass;
        this.serverUrl = confUrl;
        this.pluginKey = pluginKey;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    protected void init(String user, String pass, String confUrl) {
        this.username = user;
        this.password = pass;
        this.serverUrl = confUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoFailureException, MojoExecutionException {
        if (this.checkProperties()) {
            return;
        }
        HttpClient client = new HttpClient();
        String url = this.getActionUrl();
        GetMethod method = new GetMethod(url);
        method.setRequestHeader("X-Atlassian-Token", "no-check");
        DefaultMethodRetryHandler retryhandler = new DefaultMethodRetryHandler();
        retryhandler.setRequestSentRetryEnabled(false);
        retryhandler.setRetryCount(3);
        method.setMethodRetryHandler((MethodRetryHandler)retryhandler);
        try {
            this.getLog().info((CharSequence)(this.getTitle() + ": Connecting to server: " + this.serverUrl));
            int status = client.executeMethod((HttpMethod)method);
            if (status == 302) {
                Header location = method.getResponseHeader("Location");
                if (location == null) {
                    throw new MojoExecutionException(this.getTitle() + ": Execution failed[" + status + "]: Redirecing to an unknown location");
                }
                if (location.getValue().indexOf("/login.action") >= 0) {
                    throw new MojoExecutionException(this.getTitle() + ": Execution failed[" + status + "]: This is likely due to a non-existent or underpriviledged user: " + this.username);
                }
                throw new MojoExecutionException(this.getTitle() + ": Execution failed[" + status + "]: Redirecting to " + location.getValue());
            }
            if (status != 200) {
                throw new MojoExecutionException(this.getTitle() + ": Method failed: " + method.getStatusLine());
            }
            this.getLog().info((CharSequence)(this.getTitle() + ": Completed successfully"));
        }
        catch (HttpException e) {
            this.getLog().error((CharSequence)(this.getTitle() + ": Fatal protocol violation: " + e.getMessage()), (Throwable)e);
        }
        catch (ConnectException e) {
            this.getLog().error((CharSequence)(this.getTitle() + ": Unable to connect to '" + this.serverUrl + "': " + e.getMessage()));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)(this.getTitle() + ": Fatal transport error: " + e.getMessage()), (Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
    }

    protected abstract String getTitle();

    protected boolean checkProperties() {
        if (this.serverUrl == null || this.serverUrl.equals("")) {
            this.getLog().error((CharSequence)"Please specify the 'atlassian.pdk.server.url' property.");
            return true;
        }
        if (this.username == null || this.username.equals("")) {
            this.getLog().error((CharSequence)"Please specify the 'atlassian.pdk.server.username' property.");
            return true;
        }
        if (this.password == null || this.password.equals("")) {
            this.getLog().error((CharSequence)"Please specify the 'atlassian.pdk.server.password' property.");
            return true;
        }
        if (this.pluginKey == null || this.pluginKey.equals("")) {
            this.getLog().error((CharSequence)"Please specify the 'atlassian.plugin.key' property.");
            return true;
        }
        return false;
    }

    protected String getActionUrl() {
        return this.serverUrl + "/admin/plugins.action?os_username=" + this.urlEncode(this.username) + "&os_password=" + this.password + "&pluginKey=" + this.urlEncode(this.pluginKey) + "&mode=" + this.urlEncode(this.getMode());
    }

    protected abstract String getMode();
}

