/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.pdk;

import com.atlassian.maven.plugins.pdk.BasePluginServerMojo;
import com.atlassian.maven.plugins.pdk.RescanPluginsMojo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.MultipartPostMethod;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class InstallPluginMojo
extends BasePluginServerMojo {
    private static final String UPLOAD = "upload";
    private static final String COPY = "copy";
    protected String installMethod = "upload";
    protected File pluginsHome;
    protected File pluginFile;

    protected String getTitle() {
        return "Install Plugin";
    }

    protected boolean checkProperties() {
        if (this.installMethod == null || !UPLOAD.equalsIgnoreCase(this.installMethod) && !COPY.equalsIgnoreCase(this.installMethod)) {
            this.getLog().error((CharSequence)"Please specify either 'upload' or 'copy' for the 'atlassian.pdk.install.method' property.");
            return true;
        }
        if (COPY.equals(this.installMethod) && this.pluginsHome == null) {
            this.getLog().error((CharSequence)"Please specify the 'atlassian.pdk.server.home' property.");
            return true;
        }
        if (this.pluginFile == null) {
            this.getLog().error((CharSequence)"The plugin file could not be found.");
            return true;
        }
        if (!this.pluginFile.exists() || !this.pluginFile.isFile()) {
            this.getLog().error((CharSequence)("The required plugin file does not exist: " + this.pluginFile.getAbsolutePath()));
            return true;
        }
        return super.checkProperties();
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        if (this.checkProperties()) {
            return;
        }
        if (COPY.equals(this.installMethod)) {
            this.copyFiles(this.pluginFile, this.pluginsHome);
            this.getLog().info((CharSequence)(this.getTitle() + ": Copied the plugin to '" + this.pluginsHome + "'"));
            RescanPluginsMojo rp = new RescanPluginsMojo();
            rp.init(this.username, this.password, this.serverUrl, this.pluginKey);
            rp.execute();
        } else if (UPLOAD.equals(this.installMethod)) {
            this.uploadFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFile() throws MojoExecutionException {
        HttpClient client = new HttpClient();
        String url = this.serverUrl + "/admin/uploadplugin.action?os_username=" + this.urlEncode(this.username) + "&os_password=" + this.urlEncode(this.password);
        MultipartPostMethod filePost = new MultipartPostMethod(url);
        filePost.setFollowRedirects(false);
        try {
            filePost.addParameter("file_0", this.pluginFile.getName(), this.pluginFile);
            client.setConnectionTimeout(5000);
            this.getLog().info((CharSequence)(this.getTitle() + ": Uploading '" + this.pluginFile.getName() + "' to server: " + this.serverUrl));
            int status = client.executeMethod((HttpMethod)filePost);
            if (status == 302) {
                Header location = filePost.getResponseHeader("Location");
                if (location == null) {
                    throw new MojoExecutionException(this.getTitle() + ": Upload failed[" + status + "]: Redirecing to an unknown location");
                }
                if (location.getValue().indexOf("/login.action") >= 0) {
                    throw new MojoExecutionException(this.getTitle() + ": Upload failed[" + status + "]: This is likely due to a non-existent or underpriviledged user: " + this.username);
                }
                if (location.getValue().indexOf("/plugins.action") < 0) {
                    throw new MojoExecutionException(this.getTitle() + ": Upload failed[" + status + "]: Redirecting to " + location.getValue());
                }
            } else if (status != 200) {
                throw new MojoExecutionException(this.getTitle() + ": Upload failed[" + status + "]: " + HttpStatus.getStatusText((int)status));
            }
            this.getLog().info((CharSequence)(this.getTitle() + ": Completed successfully[" + status + "]."));
        }
        catch (ConnectException e) {
            this.getLog().error((CharSequence)(this.getTitle() + ": Unable to connect to '" + this.serverUrl + "': " + e.getMessage()));
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)(this.getTitle() + ": Unable to find file to upload: " + e.getMessage()));
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            filePost.releaseConnection();
        }
    }

    protected String getMode() {
        return null;
    }
}

