package com.atlassian.maven.plugins.updater;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

public class MpacData {
    @JsonIgnoreProperties(ignoreUnknown = true)
    static class AppKey {
        @JsonProperty
        private final String appSoftwareId;

        @JsonCreator
        public AppKey(@JsonProperty("appSoftwareId") String appSoftwareId) {
            this.appSoftwareId = appSoftwareId;
        }

        public String getAppSoftwareId() {
            return appSoftwareId;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    static class AppSoftwareVersion {
        @JsonProperty
        private final Version[] versions;

        @JsonCreator
        public AppSoftwareVersion(@JsonProperty("versions") Version[] versions) {
            this.versions = versions;
        }

        public Version[] getVersions() {
            return versions;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    static class Version {
        @JsonProperty
        private final FrameworkDetails frameworkDetails;

        @JsonProperty
        private final String versionNumber;

        @JsonCreator
        public Version(
                @JsonProperty("frameworkDetails") FrameworkDetails frameworkDetails,
                @JsonProperty("versionNumber") String versionNumber) {
            this.frameworkDetails = frameworkDetails;
            this.versionNumber = versionNumber;
        }

        public FrameworkDetails getFrameworkDetails() {
            return frameworkDetails;
        }

        public String getVersionNumber() {
            return versionNumber;
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        static class FrameworkDetails {
            @JsonProperty
            private final Attributes attributes;

            @JsonCreator
            public FrameworkDetails(@JsonProperty("attributes") Attributes attributes) {
                this.attributes = attributes;
            }

            public Attributes getAttributes() {
                return attributes;
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            static class Attributes {
                @JsonProperty
                private final String binaryUrl;

                @JsonCreator
                public Attributes(@JsonProperty("binaryUrl") String binaryUrl) {
                    this.binaryUrl = binaryUrl;
                }

                public String getBinaryUrl() {
                    return binaryUrl;
                }
            }
        }
    }
}
