package com.atlassian.maven.plugins.amps;

import com.atlassian.upm.signing.tool.CustomCertificateProperties;

public class CustomCertificateBuilder implements CustomCertificateProperties {

    private String issuer;

    private String name;

    private String duration;

    private String startOffset;

    public String getStartOffset() {
        return startOffset;
    }

    public void setStartOffset(String startOffset) {
        this.startOffset = startOffset;
    }

    public String getIssuer() {
        return issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getName() {
        String notNull = name == null ? issuer : name;
        return notNull.replaceAll("\\s", "_");
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDuration() {
        return duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public boolean isEmpty() {
        return name == null && issuer == null && duration == null && startOffset == null;
    }
}
