/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.mojoexecutor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class MavenCompatibilityHelper {
    private static final Logger logger = LoggerFactory.getLogger(MavenCompatibilityHelper.class);
    private static Method getRepositorySession;
    private static Method loadPlugin;

    public static PluginDescriptor loadPluginDescriptor(Plugin plugin, MojoExecutor.ExecutionEnvironment env, MavenSession session) throws PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException, PluginNotFoundException, MojoExecutionException {
        try {
            Object repositorySession = getRepositorySession.invoke((Object)session, new Object[0]);
            BuildPluginManager pluginManager = env.getPluginManager();
            List repositories = null;
            if (session.getCurrentProject() != null) {
                repositories = session.getCurrentProject().getRemotePluginRepositories();
            }
            logger.debug("Attempting to load plugin {} using pluginManager {} and repositories {}", new Object[]{plugin, pluginManager, repositories});
            return (PluginDescriptor)loadPlugin.invoke((Object)pluginManager, plugin, repositories, repositorySession);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Unable to access plugin", (Exception)e);
        }
        catch (InvocationTargetException e) {
            logger.debug("Unable to invoke plugin", e.getCause());
            if (e.getCause() instanceof PluginNotFoundException) {
                throw (PluginNotFoundException)e.getCause();
            }
            if (e.getCause() instanceof PluginResolutionException) {
                throw (PluginResolutionException)e.getCause();
            }
            if (e.getCause() instanceof PluginDescriptorParsingException) {
                throw (PluginDescriptorParsingException)e.getCause();
            }
            if (e.getCause() instanceof InvalidPluginDescriptorException) {
                throw (InvalidPluginDescriptorException)e.getCause();
            }
            throw new MojoExecutionException("Unable to invoke plugin", e.getCause());
        }
    }

    static {
        for (Method m : MavenSession.class.getMethods()) {
            if (!"getRepositorySession".equals(m.getName())) continue;
            getRepositorySession = m;
            break;
        }
        if (getRepositorySession == null) {
            throw new ExceptionInInitializerError("Unable to locate getRepositorySession method");
        }
        for (Method m : BuildPluginManager.class.getMethods()) {
            if (!"loadPlugin".equals(m.getName())) continue;
            loadPlugin = m;
            break;
        }
        if (loadPlugin == null) {
            throw new ExceptionInInitializerError("Unable to locate loadPluginDescriptor method");
        }
    }
}

