/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.manager;

import com.atlassian.maven.plugins.amps.ProductArtifact;
import java.io.File;
import javax.annotation.Nonnull;

class Container
extends ProductArtifact {
    private final String id;
    private final String type;
    private final String classifier;

    Container(String id, String groupId, String artifactId, String version) {
        super(groupId, artifactId, version);
        this.id = id;
        this.type = "installed";
        this.classifier = "";
    }

    Container(String id, String groupId, String artifactId, String version, String classifier) {
        super(groupId, artifactId, version);
        this.id = id;
        this.type = "installed";
        this.classifier = classifier;
    }

    Container(String id) {
        this.id = id;
        this.type = "embedded";
        this.classifier = "";
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean isEmbedded() {
        return "embedded".equals(this.type);
    }

    @Nonnull
    public String getRootDirectory(String buildDir) {
        return buildDir + File.separator + "container" + File.separator + this.getId();
    }

    @Nonnull
    public String getInstallDirectory(String buildDir) {
        return this.getRootDirectory(buildDir) + File.separator + this.getFileName();
    }

    @Nonnull
    public String getFileName() {
        if (this.isEmbedded()) {
            return this.getId();
        }
        String version = this.getVersion().replace("-atlassian-hosted", "");
        return this.getArtifactId() + "-" + version;
    }

    @Nonnull
    public String getConfigDirectory(String buildDir, String productId) {
        return this.getRootDirectory(buildDir) + File.separator + "cargo-" + productId + "-home";
    }
}

