/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Node;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.atlassian.maven.plugins.amps.util.ZipUtils;
import com.atlassian.maven.plugins.amps.util.ant.AntJavaExecutorThread;
import com.atlassian.maven.plugins.amps.util.ant.JavaTaskFactory;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.repository.RepositorySystem;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;

public class FeCruProductHandler
extends AbstractProductHandler {
    private static final int STARTUP_CHECK_DELAY = 1000;
    private static final String FISHEYE_INST = "fisheye.inst";
    private static final String PRODUCT_GROUP_ID = "com.atlassian.crucible";
    private static final String PRODUCT_ARTIFACT_ID = "atlassian-crucible";
    private static final String TEST_DATA_GROUP_ID = "com.atlassian.fecru";
    private static final String TEST_DATA_ARTIFACT_ID = "amps-fecru";
    private static final String FECRU_TIMESTAMP_FORMAT = "yyyyMMddHHmmss";
    private final JavaTaskFactory javaTaskFactory;

    public static boolean isFecruRelease(ArtifactVersion version, Artifact artifact) {
        return FeCruProductHandler.isFecruArtifact(artifact) && FeCruProductHandler.isFecruTimestamp(version.getQualifier());
    }

    private static boolean isFecruTimestamp(String qualifier) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(FECRU_TIMESTAMP_FORMAT);
        dateFormat.setLenient(false);
        Date releaseDate = ((DateFormat)dateFormat).parse(qualifier, new ParsePosition(0));
        return releaseDate != null;
    }

    public static boolean isFecruArtifact(Artifact artifact) {
        return FeCruProductHandler.isProductArtifact(artifact) || FeCruProductHandler.isTestResourcesArtifact(artifact);
    }

    public static boolean isProductArtifact(Artifact artifact) {
        return PRODUCT_GROUP_ID.equals(artifact.getGroupId()) && PRODUCT_ARTIFACT_ID.equals(artifact.getArtifactId());
    }

    public static boolean isTestResourcesArtifact(Artifact artifact) {
        return TEST_DATA_GROUP_ID.equals(artifact.getGroupId()) && TEST_DATA_ARTIFACT_ID.equals(artifact.getArtifactId());
    }

    public FeCruProductHandler(MavenContext context, MavenGoals goals, RepositorySystem repositorySystem, ArtifactResolver artifactResolver) {
        super(context, goals, new FeCruPluginProvider(), repositorySystem, artifactResolver);
        this.javaTaskFactory = new JavaTaskFactory(this.log);
    }

    @Override
    @Nonnull
    public String getId() {
        return "fecru";
    }

    @Override
    @Nonnull
    public ProductArtifact getArtifact() {
        return new ProductArtifact(PRODUCT_GROUP_ID, PRODUCT_ARTIFACT_ID, "RELEASE");
    }

    @Override
    public int getDefaultHttpPort() {
        return 3990;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 8443;
    }

    @Override
    public final void stop(@Nonnull Product product) throws MojoExecutionException {
        int webPort = product.getSingleNodeWebPort();
        this.log.info((CharSequence)("Stopping " + product.getInstanceId() + " on ports " + webPort + " (http) and " + FeCruProductHandler.controlPort(webPort) + " (control)"));
        try {
            this.execFishEyeCmd("stop", product, false);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to stop FishEye/Crucible instance at " + product.getServer() + ":" + webPort);
        }
        this.waitForFishEyeToStop(product);
    }

    @Override
    @Nonnull
    protected List<ConfigFileUtils.Replacement> getReplacements(@Nonnull Product product, int nodeIndex) {
        List<ConfigFileUtils.Replacement> replacements = super.getReplacements(product, nodeIndex);
        File homeDirectory = this.getHomeDirectory(product);
        int webPort = product.getSingleNodeWebPort();
        replacements.add(new ConfigFileUtils.Replacement("@CONTROL_BIND@", String.valueOf(FeCruProductHandler.controlPort(webPort))));
        replacements.add(new ConfigFileUtils.Replacement("@HTTP_BIND@", String.valueOf(webPort)));
        replacements.add(new ConfigFileUtils.Replacement("@HTTP_CONTEXT@", String.valueOf(product.getContextPath()), false));
        replacements.add(new ConfigFileUtils.Replacement("@HOME_DIR@", homeDirectory.getAbsolutePath()));
        replacements.add(new ConfigFileUtils.Replacement("@SITE_URL@", this.siteUrl(product)));
        return replacements;
    }

    @Override
    @Nonnull
    protected List<File> getConfigFiles(@Nonnull Product product, @Nonnull File homeDir) {
        List<File> configFiles = super.getConfigFiles(product, homeDir);
        configFiles.add(new File(homeDir, "config.xml"));
        configFiles.add(new File(homeDir, "var/data/crudb/crucible.script"));
        return configFiles;
    }

    @Override
    @Nonnull
    protected File extractApplication(Product product) throws MojoExecutionException {
        File appDir = ProjectUtils.createDirectory(this.getAppDirectory(product));
        ProductArtifact artifact = this.getArtifact(product);
        File cruDistZip = this.goals.copyZip(this.getBuildDirectory(), artifact, "test-dist.zip");
        try {
            int nestingLevel = ZipUtils.countNestingLevel(cruDistZip);
            ZipUtils.unzip(cruDistZip, appDir.getPath(), nestingLevel > 0 ? 1 : 0);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to extract application ZIP artifact", (Exception)ex);
        }
        return appDir;
    }

    protected File getAppDirectory(Product ctx) {
        return new File(this.getBaseDirectory(ctx), ctx.getId() + "-" + ctx.getVersion());
    }

    @Override
    @Nonnull
    public final Optional<ProductArtifact> getTestResourcesArtifact() {
        return Optional.of(new ProductArtifact(TEST_DATA_GROUP_ID, TEST_DATA_ARTIFACT_ID));
    }

    @Override
    @Nonnull
    protected Map<String, String> getSystemProperties(Product product, int nodeIndex) {
        return Collections.singletonMap(FISHEYE_INST, this.getHomeDirectory(product).getAbsolutePath());
    }

    private File getHomeDirectory(Product product) {
        List<File> homeDirectories = this.getHomeDirectories(product);
        if (homeDirectories.size() != 1) {
            throw new IllegalStateException("Expected one home directory but found " + homeDirectories);
        }
        return homeDirectories.get(0);
    }

    @Override
    @Nonnull
    protected File getBundledPluginPath(Product product, File productDir) {
        return new File(productDir, "plugins/bundled-plugins.zip");
    }

    @Override
    @Nonnull
    protected final Optional<File> getUserInstalledPluginsDirectory(Product product, File appDir, File homeDir) {
        return Optional.of(new File(new File(new File(homeDir, "var"), "plugins"), "user"));
    }

    @Override
    protected boolean supportsStaticPlugins() {
        return false;
    }

    @Override
    @Nonnull
    protected final List<Node> startProduct(Product product, File productFile, List<Map<String, String>> systemProperties) throws MojoExecutionException {
        AntJavaExecutorThread thread;
        int webPort = product.getSingleNodeWebPort();
        this.log.info((CharSequence)("Starting " + product.getInstanceId() + " on ports " + webPort + " (http) and " + FeCruProductHandler.controlPort(webPort) + " (control)"));
        try {
            thread = this.execFishEyeCmd("run", product, true);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting fisheye.", e);
        }
        this.waitForFishEyeToStart(product, thread);
        return product.getNodes();
    }

    private void waitForFishEyeToStart(Product ctx, AntJavaExecutorThread thread) throws MojoExecutionException {
        boolean connected = false;
        int waited = 0;
        int webPort = ctx.getSingleNodeWebPort();
        while (!connected) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                new Socket("localhost", webPort).close();
                connected = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (thread.isFinished()) {
                throw new MojoExecutionException("Fisheye failed to start.", (Exception)((Object)thread.getBuildException()));
            }
            if (waited++ * 1000 <= ctx.getStartupTimeout()) continue;
            throw new MojoExecutionException("FishEye took longer than " + ctx.getStartupTimeout() + "ms to start!");
        }
    }

    private void waitForFishEyeToStop(Product ctx) throws MojoExecutionException {
        boolean connected = true;
        int waited = 0;
        int webPort = ctx.getSingleNodeWebPort();
        while (connected) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                new Socket("localhost", webPort).close();
            }
            catch (IOException e) {
                connected = false;
            }
            if (waited++ * 1000 <= ctx.getShutdownTimeout()) continue;
            throw new MojoExecutionException("FishEye took longer than " + ctx.getShutdownTimeout() + "ms to stop!");
        }
    }

    private AntJavaExecutorThread execFishEyeCmd(String bootCommand, Product product, boolean useDebugArgs) {
        List<Map<String, String>> systemProperties = this.mergeSystemProperties(product);
        if (systemProperties.size() != 1) {
            throw new IllegalStateException("Expected one map but found " + systemProperties);
        }
        Java java = this.javaTaskFactory.newJavaTask(new JavaTaskFactory.Parameters.Builder().output(product.getOutput()).jvm(product.getJvm()).jvmArgs(product.getJvmArgs() + (useDebugArgs ? product.getSingleNodeDebugArgs() : "")).systemProperties(systemProperties.get(0)).build());
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(this.getAppDirectory(product), "fisheyeboot.jar"));
        java.setClassname("com.cenqua.fisheye.FishEyeCtl");
        java.createArg().setValue(bootCommand);
        AntJavaExecutorThread javaThread = new AntJavaExecutorThread(java);
        javaThread.start();
        return javaThread;
    }

    protected File getBuildDirectory() {
        return new File(this.project.getBuild().getDirectory());
    }

    private String siteUrl(Product ctx) {
        return "http://" + ctx.getServer() + ":" + ctx.getSingleNodeWebPort() + ctx.getContextPath();
    }

    private static int controlPort(int httpPort) {
        return httpPort * 10 + 1;
    }

    @Override
    protected void cleanupProductHomeForZip(@Nonnull Product product, @Nonnull File homeDirectory) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, homeDirectory);
        FileUtils.deleteQuietly((File)new File(homeDirectory, "var/log"));
        FileUtils.deleteQuietly((File)new File(homeDirectory, "var/plugins"));
        FileUtils.deleteQuietly((File)new File(homeDirectory, "cache/plugins"));
    }

    @Override
    @Nonnull
    protected String getLibArtifactTargetDir() {
        return "lib";
    }

    @Override
    @Nonnull
    protected File getRootDir(File tmpDir, Product product) throws IOException {
        File[] topLevelFiles = Optional.ofNullable(tmpDir.listFiles()).orElse(new File[0]);
        if (topLevelFiles.length == 1) {
            return topLevelFiles[0];
        }
        this.log.info((CharSequence)"Non-standard zip structure identified. Assume using older non-standard FECRU zip format");
        this.log.info((CharSequence)"Therefore reorganise unpacked data directories to match standard format.");
        File tmpGen = new File(tmpDir, "generated-resources");
        File tmpHome = new File(tmpGen, product.getId() + "-home");
        for (File file : topLevelFiles) {
            FileUtils.moveToDirectory((File)file, (File)tmpHome, (boolean)true);
        }
        return tmpGen;
    }

    private static class FeCruPluginProvider
    extends AbstractPluginProvider {
        private FeCruPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-fisheye-plugin", salVersion));
        }
    }
}

