/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.PluginProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginProvider
implements PluginProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPluginProvider.class);

    @Override
    public final List<ProductArtifact> provide(Product product, ProductArtifact selfInstalled) {
        NonOverridingArtifacts artifacts = new NonOverridingArtifacts(selfInstalled, product.getPluginArtifacts());
        if (product.getSalVersion() != null) {
            artifacts.addAll(this.getSalArtifacts(product.getSalVersion()));
        }
        if (product.getPdkVersion() != null) {
            artifacts.addAll(this.getPdkInstallArtifacts(product.getPdkVersion()));
        }
        if (product.getRestVersion() != null) {
            artifacts.addAll(this.getRestArtifacts(product.getRestVersion()));
        }
        if (product.isEnableWebConsole().booleanValue() && product.getWebConsoleVersion() != null) {
            artifacts.addAll(this.getWebConsoleArtifacts(product.getWebConsoleVersion()));
        }
        if (product.isEnableAchoo().booleanValue() && product.getAchooVersion() != null) {
            artifacts.addAll(this.getAchooArtifacts(product.getAchooVersion()));
        }
        if (product.isEnableDevToolbox().booleanValue() && product.getDevToolboxVersion() != null) {
            artifacts.addAll(this.getDevToolboxArtifacts(product.getDevToolboxVersion()));
        }
        if (product.isEnablePde().booleanValue() && product.getPdeVersion() != null) {
            artifacts.addAll(this.getPdeArtifacts(product.getPdeVersion()));
        }
        if (product.isEnableQuickReload().booleanValue() && product.getQuickReloadVersion() != null) {
            artifacts.addAll(this.getQuickReloadArtifacts(product.getQuickReloadVersion()));
        }
        if (product.isEnablePluginViewer().booleanValue() && product.getPluginViewerVersion() != null) {
            artifacts.addAll(this.getPluginViewerArtifacts(product.getPluginViewerVersion()));
        }
        return artifacts.getProvided();
    }

    protected abstract Collection<ProductArtifact> getSalArtifacts(String var1);

    protected Collection<ProductArtifact> getPdkInstallArtifacts(String pdkInstallVersion) {
        return Collections.singletonList(new ProductArtifact("com.atlassian.pdkinstall", "pdkinstall-plugin", pdkInstallVersion));
    }

    protected Collection<ProductArtifact> getWebConsoleArtifacts(String webConsoleVersion) {
        return Arrays.asList(new ProductArtifact("org.apache.felix", "org.apache.felix.webconsole", webConsoleVersion), new ProductArtifact("org.apache.felix", "org.osgi.compendium", "1.2.0"), new ProductArtifact("com.atlassian.labs.httpservice", "httpservice-bridge", "0.6.2"));
    }

    protected Collection<ProductArtifact> getAchooArtifacts(String version) {
        return Collections.singletonList(new ProductArtifact("com.atlassian.support", "achoo-database-console-plugin", version));
    }

    protected Collection<ProductArtifact> getQuickReloadArtifacts(String version) {
        return Collections.singletonList(new ProductArtifact("com.atlassian.labs.plugins", "quickreload", version));
    }

    protected Collection<ProductArtifact> getPluginViewerArtifacts(String version) {
        return Collections.singletonList(new ProductArtifact("com.atlassian", "plugins-viewer-plugin", version));
    }

    protected Collection<ProductArtifact> getDevToolboxArtifacts(String devToolboxVersion) {
        ArrayList<ProductArtifact> artifacts = new ArrayList<ProductArtifact>();
        artifacts.add(new ProductArtifact("com.atlassian.devrel", "developer-toolbox-plugin", devToolboxVersion));
        int devToolboxMajorVersion = Integer.parseInt(devToolboxVersion.split("\\.")[0]);
        int devToolboxMinorVersion = Integer.parseInt(devToolboxVersion.split("\\.")[1]);
        if (devToolboxVersion.isEmpty()) {
            return artifacts;
        }
        if (devToolboxMajorVersion < 3 || devToolboxMajorVersion == 3 && devToolboxMinorVersion < 2) {
            artifacts.add(new ProductArtifact("com.atlassian.labs", "rest-api-browser", "3.2.8"));
        }
        return artifacts;
    }

    protected Collection<ProductArtifact> getPdeArtifacts(String pdeVersion) {
        return Collections.singletonList(new ProductArtifact("com.atlassian.plugins", "plugin-data-editor", pdeVersion));
    }

    protected Collection<ProductArtifact> getRestArtifacts(String restVersion) {
        return Collections.singletonList(new ProductArtifact("com.atlassian.plugins.rest", "atlassian-rest-module", restVersion));
    }

    private static class NonOverridingArtifacts {
        private final List<ProductArtifact> defined;
        private final List<ProductArtifact> provided;

        private NonOverridingArtifacts(@Nullable ProductArtifact selfInstalled, List<ProductArtifact> defined) {
            this.defined = new ArrayList<ProductArtifact>(defined);
            if (selfInstalled != null) {
                this.defined.add(selfInstalled);
            }
            this.provided = new ArrayList<ProductArtifact>(defined);
        }

        private void addIfNotOverriding(ProductArtifact toAdd) {
            Optional<ProductArtifact> potentialOverride = this.defined.stream().filter(definedArtifact -> Objects.equals(definedArtifact.getArtifactId(), toAdd.getArtifactId())).findFirst();
            if (potentialOverride.isPresent()) {
                ProductArtifact overridenArtifact = potentialOverride.get();
                LOGGER.warn("Defined artifact '{}' would be overriden by '{}'. Ignored.", (Object)overridenArtifact, (Object)toAdd);
            } else {
                this.provided.add(toAdd);
            }
        }

        private void addAll(Collection<ProductArtifact> productArtifacts) {
            for (ProductArtifact productArtifact : productArtifacts) {
                this.addIfNotOverriding(productArtifact);
            }
        }

        private List<ProductArtifact> getProvided() {
            return this.provided;
        }
    }
}

