/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.verification.impl;

import com.atlassian.maven.plugins.amps.frontend.association.verification.DeclarationsChecker;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.FailurePreferences;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.NestedModuleDeclarationData;
import com.atlassian.maven.plugins.amps.frontend.association.verification.utils.ArtifactPathUtils;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeclarationsCheckerImpl
implements DeclarationsChecker {
    private final Logger logger = LoggerFactory.getLogger((String)"ROOT");
    private FailurePreferences failurePreferences;
    private boolean undeclaredFilesFound = false;
    private boolean extraDeclarationsFound = false;

    @Override
    public void setFailurePreferences(FailurePreferences failurePreferences) {
        this.failurePreferences = failurePreferences;
    }

    @Override
    public void verifyModule(TFile moduleRoot, Set<String> declarations, Set<String> files) {
        this.logger.info("Verifying directory: {}", (Object)moduleRoot.getPath());
        if (!declarations.equals(ArtifactPathUtils.normalizePathSeparators(declarations)) || !files.equals(ArtifactPathUtils.normalizePathSeparators(files))) {
            throw new IllegalArgumentException("Paths should be normalized before verification:\ndeclarations: " + declarations + "\nfiles: " + files);
        }
        this.checkDeclarationsExist(declarations);
        this.checkUndeclaredFiles(declarations, files);
        this.checkExtraDeclarations(declarations, files);
    }

    @Override
    public void verifyExternalModule(TFile moduleRoot, NestedModuleDeclarationData nestedModuleData, Set<String> files) {
        Set<String> declarations = nestedModuleData.getDeclaredFiles();
        this.verifyModule(moduleRoot, declarations, files);
    }

    private void checkDeclarationsExist(Set<String> declarations) {
        if (declarations.isEmpty()) {
            this.logger.warn("No declarations provided for the module!");
        }
    }

    private void checkExtraDeclarations(Set<String> declarations, Set<String> files) {
        Collection<String> extraDeclarations = this.filterOut(declarations, files);
        if (!extraDeclarations.isEmpty()) {
            this.extraDeclarationsFound = true;
            this.logExtraDeclarations(extraDeclarations);
        }
    }

    private void checkUndeclaredFiles(Set<String> declarations, Set<String> files) {
        Collection<String> undeclaredFiles = this.filterOut(files, declarations);
        if (!undeclaredFiles.isEmpty()) {
            this.undeclaredFilesFound = true;
            this.logUndeclaredFiles(undeclaredFiles);
        }
    }

    private Collection<String> filterOut(Set<String> originalSet, Set<String> elementsToRemove) {
        return originalSet.stream().filter(file -> !elementsToRemove.contains(file)).collect(Collectors.toList());
    }

    private void logExtraDeclarations(Collection<String> extraDeclarations) {
        String sortedUndeclaredFiles = extraDeclarations.stream().sorted().collect(Collectors.joining(",\n\t"));
        String logMessage = String.format("Extra declarations detected: [\n\t%s\n]", sortedUndeclaredFiles);
        this.logWithPreferredLevel(logMessage, this.failurePreferences.isFailOnExtraDeclarations());
    }

    private void logUndeclaredFiles(Collection<String> undeclaredFiles) {
        String sortedUndeclaredFiles = undeclaredFiles.stream().sorted().collect(Collectors.joining(",\n\t"));
        String logMessage = String.format("Undeclared files detected! First check that they are not left over from switching branches (i.e. try running 'mvn clean' first). If they are supposed to be bundled, check them for third-party code (all 3rd-party code must be installed and bundled by using the package.json file so that our SBOMs are accurate) then declare the files in the pom.xml file. Learn more: https://hello.atlassian.net/wiki/spaces/DCCore/pages/3400121615\n\nThe undeclared files were : [\n\t%s\n]", sortedUndeclaredFiles);
        this.logWithPreferredLevel(logMessage, this.failurePreferences.isFailOnUndeclaredFiles());
    }

    private void logWithPreferredLevel(String message, boolean willFail) {
        if (willFail) {
            this.logger.error(message);
        } else {
            this.logger.warn(message);
        }
    }

    @Override
    public void finalizeChecks() throws MojoExecutionException {
        this.finalizeUndeclaredFileChecks();
        this.finalizeExtraDeclarationChecks();
    }

    private void finalizeUndeclaredFileChecks() throws MojoExecutionException {
        if (this.failurePreferences.isFailOnUndeclaredFiles() && this.undeclaredFilesFound) {
            throw new MojoExecutionException("There were undeclared files found when verifying frontend manifest associations. See logs above for a complete list of problems.");
        }
    }

    private void finalizeExtraDeclarationChecks() throws MojoExecutionException {
        if (this.failurePreferences.isFailOnExtraDeclarations() && this.extraDeclarationsFound) {
            throw new MojoExecutionException("There were extra file declarations found when verifying frontend manifest associations. See logs above for a complete list of problems.");
        }
    }
}

