/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.RunMojo;
import com.atlassian.maven.plugins.amps.analytics.event.AnalyticsEvent;
import com.atlassian.maven.plugins.amps.analytics.event.impl.AnalyticsEventFactory;
import com.atlassian.maven.plugins.amps.util.DebugUtils;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="debug", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.PACKAGE)
public class DebugMojo
extends RunMojo {
    @Parameter(property="jvm.debug.port", defaultValue="5005")
    private int jvmDebugPort;
    @Parameter(property="jvm.debug.suspend")
    private boolean jvmDebugSuspend;

    @Override
    protected void beforeStart(List<Product> products) throws MojoExecutionException {
        DebugUtils.setNodeDebugPorts(products, this.jvmDebugPort);
        for (Product product : products) {
            product.defaultJvmArgs(this.jvmArgs);
            product.setNodeDebugArgs(this.jvmDebugSuspend, this.getLog());
        }
        if (this.writePropertiesToFile) {
            this.propertiesToWriteToFile.putAll(DebugUtils.getDebugPortProperties(products));
        }
    }

    @Override
    @Nonnull
    protected AnalyticsEvent getAnalyticsEvent() {
        return AnalyticsEventFactory.debug();
    }
}

