/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.manager;

import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class BaseUrlUtils {
    public static String getBaseUrl(String server, int actualWebPort, @Nullable String contextPath) {
        return BaseUrlUtils.formatServer(server) + BaseUrlUtils.formatPort(server, actualWebPort) + BaseUrlUtils.formatContextPath(contextPath);
    }

    private static String formatServer(String server) {
        if (StringUtils.isBlank((CharSequence)server)) {
            throw new IllegalArgumentException(String.format("Invalid server name '%s'", server));
        }
        String schemeRegex = "^https?://";
        if (!Pattern.compile(schemeRegex).matcher(server).find()) {
            server = "http://" + server;
        }
        return server;
    }

    private static String formatPort(String server, int port) {
        int defaultPort = 80;
        if (server.startsWith("https://")) {
            defaultPort = 443;
        }
        return port != defaultPort ? ":" + port : "";
    }

    private static String formatContextPath(String contextPath) {
        if (StringUtils.isBlank((CharSequence)contextPath)) {
            return "";
        }
        return StringUtils.prependIfMissing((String)contextPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    private BaseUrlUtils() {
    }
}

