/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.analytics.impl;

import java.util.Locale;
import java.util.Objects;

public class UserAgent {
    private static final String HEADER_VALUE_FORMAT = "%s/%s(compatible; %s %s; %s %s; %s-%s)";
    private final Locale locale;
    private final String operatingSystemName;
    private final String operatingSystemVersion;
    private final String product;
    private final String productVersion;

    public static UserAgent getInstance(String ampsVersion, String sdkVersion) {
        boolean usingSdk = System.getenv("ATLAS_VERSION") != null;
        String product = usingSdk ? "Atlassian-SDK" : "Atlassian-AMPS-Plugin";
        String productVersion = usingSdk ? sdkVersion : ampsVersion;
        return new UserAgent(Locale.getDefault(), System.getProperty("os.name"), System.getProperty("os.version"), product, productVersion);
    }

    UserAgent(Locale locale, String operatingSystemName, String operatingSystemVersion, String product, String productVersion) {
        this.locale = Objects.requireNonNull(locale);
        this.operatingSystemName = Objects.requireNonNull(operatingSystemName);
        this.operatingSystemVersion = Objects.requireNonNull(operatingSystemVersion);
        this.product = Objects.requireNonNull(product);
        this.productVersion = Objects.requireNonNull(productVersion);
    }

    public String getHeaderValue() {
        return String.format(HEADER_VALUE_FORMAT, this.product, this.productVersion, this.product, this.productVersion, this.operatingSystemName, this.operatingSystemVersion, this.locale.getLanguage().toLowerCase(), this.locale.getCountry().toLowerCase());
    }
}

