/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.BannedArtifactsProvider;
import com.atlassian.maven.plugins.amps.BannedDependencies;
import com.atlassian.maven.plugins.amps.LegacyBannedDependenciesProvider;
import com.atlassian.maven.plugins.amps.PlatformDependenciesProvider;
import com.atlassian.maven.plugins.amps.PlatformDependencyProvisioningException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.twdata.maven.mojoexecutor.MojoExecutor;

class BannedDependenciesImpl
implements BannedDependencies {
    private static final Logger log = LoggerFactory.getLogger(BannedDependenciesImpl.class);
    private static final String PLATFORM_GROUP_ID = "com.atlassian.platform.dependencies";
    @Component
    private PlatformDependenciesProvider platformDependenciesProvider;
    @Component
    private LegacyBannedDependenciesProvider legacyBannedDependenciesProvider;
    @Component
    private BannedArtifactsProvider bannedArtifactsProvider;

    BannedDependenciesImpl() {
    }

    @Override
    public Set<MojoExecutor.Element> getBannedElements(Collection<String> allowedDependencies, String platformVersionRange, boolean forceInternal, boolean useLegacyDependencyList) throws PlatformDependencyProvisioningException {
        log.info("Dependencies excluded from banning: [{}]", (Object)allowedDependencies.stream().collect(Collectors.joining(", ")));
        log.info("Scanning using platform version range: '{}'", (Object)platformVersionRange);
        Set bannedDependencies = this.resolveDependencies(forceInternal, platformVersionRange, useLegacyDependencyList).stream().distinct().filter(dependency -> !allowedDependencies.contains(dependency)).collect(Collectors.toSet());
        if (log.isDebugEnabled()) {
            log.debug("Banned dependencies:\n{}", (Object)bannedDependencies.stream().sorted().collect(Collectors.joining("\n")));
        }
        return bannedDependencies.stream().map(BannedDependenciesImpl::inCompileScope).map(BannedDependenciesImpl::asExcludeElement).collect(Collectors.toSet());
    }

    private static String inCompileScope(String dependency) {
        switch (StringUtils.countMatches((CharSequence)dependency, (CharSequence)":")) {
            case 1: {
                return dependency.concat(":*:*:compile");
            }
            case 2: {
                return dependency.concat(":*:compile");
            }
            case 3: {
                return dependency.concat(":compile");
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported dependency format '%s'", dependency));
    }

    private static MojoExecutor.Element asExcludeElement(String elementValue) {
        return MojoExecutor.element(MojoExecutor.name("exclude"), elementValue);
    }

    private Collection<String> resolveDependencies(boolean forceInternal, String platformVersionRange, boolean useLegacyDependencyList) throws PlatformDependencyProvisioningException {
        if (useLegacyDependencyList) {
            log.debug("Using legacy banned dependencies list");
            return this.legacyBannedDependenciesProvider.getDependencies();
        }
        log.debug("Using banned dependencies list from platform POMs");
        Set<String> artifactIds = this.bannedArtifactsProvider.getBannedArtifacts(forceInternal);
        return this.platformDependenciesProvider.getDependencies(PLATFORM_GROUP_ID, artifactIds, platformVersionRange);
    }
}

