/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.xml;

import com.atlassian.maven.plugins.amps.xml.IdProvider;
import com.atlassian.maven.plugins.amps.xml.Namespace;
import com.atlassian.maven.plugins.amps.xml.SpringXmlBuilder;
import com.atlassian.maven.plugins.amps.xml.SpringXmlBuilderException;
import com.atlassian.plugins.codegen.ClassId;
import com.atlassian.plugins.codegen.ComponentDeclaration;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Optional;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class SpringXmlBuilderImpl
implements SpringXmlBuilder {
    private final Document document;
    private final Element root;
    private final IdProvider idProvider;

    SpringXmlBuilderImpl(Document document, Element root, IdProvider idProvider) {
        this.document = document;
        this.root = root;
        this.idProvider = idProvider;
    }

    @Override
    public SpringXmlBuilder addComponent(ComponentDeclaration componentDeclaration) {
        ClassId classId = componentDeclaration.getClassId();
        String fullClassName = classId.getFullName();
        String beanId = this.idProvider.get(classId.getName());
        Element beanElement = this.createBeansElement("bean");
        beanElement.setAttribute("id", beanId);
        beanElement.setAttribute("autowire", "default");
        beanElement.setAttribute("class", fullClassName);
        this.root.appendChild(beanElement);
        Element serviceElement = this.createOsgiElement("service");
        serviceElement.setAttribute("id", beanId + "_osgi-service");
        serviceElement.setAttribute("ref", beanId);
        this.root.appendChild(serviceElement);
        Element interfacesElement = this.createOsgiElement("interfaces");
        serviceElement.appendChild(interfacesElement);
        Element valueElement = this.createBeansElement("value");
        valueElement.setTextContent(fullClassName);
        interfacesElement.appendChild(valueElement);
        this.createServicePropertiesElement((Map<String, String>)componentDeclaration.getServiceProperties()).ifPresent(serviceElement::appendChild);
        return this;
    }

    @Override
    public void build(Writer writer) throws SpringXmlBuilderException {
        Transformer transformer;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new SpringXmlBuilderException("Unable to create an XML transformer", e);
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        this.writeXmlDeclaration(writer);
        DOMSource domSource = new DOMSource(this.document);
        try {
            transformer.transform(domSource, new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new SpringXmlBuilderException("Failed to generate XML document", e);
        }
    }

    private void writeXmlDeclaration(Writer writer) throws SpringXmlBuilderException {
        try {
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
        catch (IOException e) {
            throw new SpringXmlBuilderException("Failed to write XML declaration", e);
        }
    }

    private Optional<Element> createServicePropertiesElement(Map<String, String> serviceProperties) {
        if (serviceProperties.isEmpty()) {
            return Optional.empty();
        }
        Element servicePropertiesElement = this.createOsgiElement("service-properties");
        for (Map.Entry<String, String> propertyEntry : serviceProperties.entrySet()) {
            servicePropertiesElement.appendChild(this.createEntryElement(propertyEntry));
        }
        return Optional.of(servicePropertiesElement);
    }

    private Element createEntryElement(Map.Entry<String, String> property) {
        Element entryElement = this.createBeansElement("entry");
        entryElement.setAttribute("key", property.getKey());
        entryElement.setAttribute("value", property.getValue());
        return entryElement;
    }

    private Element createBeansElement(String tagName) {
        return this.createNamespacedElement(tagName, Namespace.BEANS);
    }

    private Element createOsgiElement(String tagName) {
        return this.createNamespacedElement(tagName, Namespace.OSGI);
    }

    private Element createNamespacedElement(String tagName, Namespace namespace) {
        return this.document.createElement(namespace.createName(tagName));
    }
}

