/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.xml;

import com.atlassian.maven.plugins.amps.xml.IdProvider;
import com.atlassian.maven.plugins.amps.xml.IdProviderFactory;
import com.atlassian.maven.plugins.amps.xml.Namespace;
import com.atlassian.maven.plugins.amps.xml.SpringXmlBuilder;
import com.atlassian.maven.plugins.amps.xml.SpringXmlBuilderException;
import com.atlassian.maven.plugins.amps.xml.SpringXmlBuilderFactory;
import com.atlassian.maven.plugins.amps.xml.SpringXmlBuilderImpl;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Named
class SpringXmlBuilderFactoryImpl
implements SpringXmlBuilderFactory {
    private static final String[] schemaLocations = new String[]{"http://www.springframework.org/schema/beans", "http://www.springframework.org/schema/context", "http://www.springframework.org/schema/beans/spring-beans.xsd", "http://www.eclipse.org/gemini/blueprint/schema/blueprint", "http://www.eclipse.org/gemini/blueprint/schema/blueprint/gemini-blueprint.xsd"};
    private final IdProviderFactory idProviderFactory;

    @Inject
    SpringXmlBuilderFactoryImpl(@Named IdProviderFactory idProviderFactory) {
        this.idProviderFactory = idProviderFactory;
    }

    @Override
    public SpringXmlBuilder create() throws SpringXmlBuilderException {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SpringXmlBuilderException("Unable to create a document builder", e);
        }
        Document document = documentBuilder.newDocument();
        document.setXmlStandalone(true);
        Element root = document.createElement("beans");
        this.addNamespaces(root);
        this.addSchemaLocations(root);
        document.appendChild(root);
        IdProvider idProvider = this.idProviderFactory.create();
        return new SpringXmlBuilderImpl(document, root, idProvider);
    }

    private void addNamespaces(Element root) {
        for (Namespace namespace : Namespace.values()) {
            root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + namespace.prefix(), namespace.uri());
        }
    }

    private void addSchemaLocations(Element root) {
        String schemaLocationString = Arrays.stream(schemaLocations).collect(Collectors.joining(" "));
        root.setAttribute(Namespace.XSI.createName("schemaLocation"), schemaLocationString);
    }
}

