/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.verification;

import com.atlassian.maven.plugins.amps.frontend.association.FeManifestAssociationConstants;
import com.atlassian.maven.plugins.amps.frontend.association.verification.ArtifactScanner;
import com.atlassian.maven.plugins.amps.frontend.association.verification.DeclarationsChecker;
import com.atlassian.maven.plugins.amps.frontend.association.verification.DeclarationsReader;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.ArtifactScanResults;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.FailurePreferences;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.ModuleScanResults;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.NestedModuleDeclarationData;
import com.atlassian.maven.plugins.amps.frontend.association.verification.utils.ArtifactPathUtils;
import com.atlassian.maven.plugins.amps.frontend.association.verification.utils.TrueZipUtils;
import com.google.common.annotations.VisibleForTesting;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="verify-fe-manifest-associations", requiresProject=false)
public class VerifyFeManifestAssociationsMojo
extends AbstractMojo {
    @Parameter(property="verify.fe.manifest.associations.inputEntrypoint", alias="verifyFeManifestAssociationsInputEntrypoint", required=true)
    private String inputEntrypoint;
    @Parameter(property="verify.fe.manifest.associations.failOnUndeclaredFiles", alias="verifyFeManifestAssociationsFailOnUndeclaredFiles", defaultValue="true")
    private Boolean failOnUndeclaredFiles;
    @Parameter(property="verify.fe.manifest.associations.failOnExtraDeclarations", alias="verifyFeManifestAssociationsFailOnExtraDeclarations", defaultValue="true")
    private Boolean failOnExtraDeclarations;
    private final Logger logger = LoggerFactory.getLogger((String)"ROOT");
    @Component
    private ArtifactScanner artifactScanner;
    @Component
    private DeclarationsReader declarationsReader;
    @Component
    private DeclarationsChecker declarationsChecker;

    public void execute() throws MojoExecutionException {
        this.logger.info("Verifying frontend manifest associations for an artifact: {}", (Object)this.inputEntrypoint);
        FailurePreferences failurePreferences = new FailurePreferences(this.failOnUndeclaredFiles, this.failOnExtraDeclarations);
        this.verifyManifestAssociations(this.inputEntrypoint, failurePreferences);
    }

    @VisibleForTesting
    protected void verifyManifestAssociations(String inputEntrypoint, FailurePreferences failurePreferences) throws MojoExecutionException {
        TrueZipUtils.configureTrueZip();
        this.declarationsChecker.setFailurePreferences(failurePreferences);
        try {
            this.scanEntrypoint(inputEntrypoint);
            this.declarationsChecker.finalizeChecks();
        }
        finally {
            TrueZipUtils.unmountTrueZip();
        }
    }

    private void scanEntrypoint(String inputEntrypoint) throws MojoExecutionException {
        ArrayList<MutablePair<TFile, ArtifactScanResults>> completeScanData = this.runRecursiveScan(inputEntrypoint);
        Map<TFile, NestedModuleDeclarationData> nestedModuleDeclarations = this.getNestedModuleDeclarations(completeScanData);
        nestedModuleDeclarations.putAll(VerifyFeManifestAssociationsMojo.getExpandedNestedModuleDeclarations(nestedModuleDeclarations));
        this.verifyAllModules(completeScanData, nestedModuleDeclarations);
    }

    private void verifyAllModules(ArrayList<MutablePair<TFile, ArtifactScanResults>> completeScanData, Map<TFile, NestedModuleDeclarationData> nestedModuleDeclarations) throws MojoExecutionException {
        for (MutablePair<TFile, ArtifactScanResults> artifactScanData : completeScanData) {
            ArtifactScanResults scanResults = (ArtifactScanResults)((Object)artifactScanData.getRight());
            this.verifyModules(scanResults.getModules(), nestedModuleDeclarations);
        }
    }

    private static Map<TFile, NestedModuleDeclarationData> getExpandedNestedModuleDeclarations(Map<TFile, NestedModuleDeclarationData> nestedModuleDeclarations) {
        HashMap<TFile, NestedModuleDeclarationData> expandedModuleDeclarations = new HashMap<TFile, NestedModuleDeclarationData>();
        block0: for (Map.Entry<TFile, NestedModuleDeclarationData> nestedModuleData : nestedModuleDeclarations.entrySet()) {
            TFile parent;
            TFile modulePath = nestedModuleData.getKey();
            NestedModuleDeclarationData moduleData = nestedModuleData.getValue();
            String nestedModuleName = modulePath.getName();
            while ((parent = modulePath.getParentFile()) != null && parent.getPath().endsWith(FeManifestAssociationConstants.METAINF_LIB_DIRECTORY_NAME)) {
                if (!modulePath.getName().equals(nestedModuleName)) {
                    TFile modulePathInParent = new TFile((File)parent, nestedModuleName);
                    if (expandedModuleDeclarations.containsKey(modulePathInParent)) continue block0;
                    expandedModuleDeclarations.put(modulePathInParent, moduleData);
                }
                assert (parent.getParentFile() != null);
                modulePath = parent.getParentFile().getParentFile();
                assert (modulePath != null);
            }
        }
        return expandedModuleDeclarations;
    }

    private Map<TFile, NestedModuleDeclarationData> getNestedModuleDeclarations(ArrayList<MutablePair<TFile, ArtifactScanResults>> completeScanData) throws MojoExecutionException {
        HashMap<TFile, NestedModuleDeclarationData> nestedModuleDeclarations = new HashMap<TFile, NestedModuleDeclarationData>();
        for (MutablePair<TFile, ArtifactScanResults> artifactScanData : completeScanData) {
            ArtifactScanResults scanResults = (ArtifactScanResults)((Object)artifactScanData.getRight());
            nestedModuleDeclarations.putAll(this.processNestedDeclarations(scanResults.getModules()));
        }
        return nestedModuleDeclarations;
    }

    private ArrayList<MutablePair<TFile, ArtifactScanResults>> runRecursiveScan(String inputEntrypoint) throws MojoExecutionException {
        ArrayList<MutablePair<TFile, ArtifactScanResults>> result = new ArrayList<MutablePair<TFile, ArtifactScanResults>>();
        ArrayDeque<TFile> queue = new ArrayDeque<TFile>();
        TFile root = new TFile(inputEntrypoint);
        queue.add(root);
        while (!queue.isEmpty()) {
            TFile currentArtifact = (TFile)queue.poll();
            ArtifactScanResults scanResults = this.artifactScanner.scan(currentArtifact);
            result.add((MutablePair<TFile, ArtifactScanResults>)new MutablePair((Object)currentArtifact, (Object)scanResults));
            queue.addAll(scanResults.getArchiveFiles());
        }
        return result;
    }

    private Map<TFile, NestedModuleDeclarationData> processNestedDeclarations(Map<TFile, ModuleScanResults> modules) throws MojoExecutionException {
        HashMap<TFile, NestedModuleDeclarationData> nestedModuleDeclarations = new HashMap<TFile, NestedModuleDeclarationData>();
        for (Map.Entry<TFile, ModuleScanResults> module : modules.entrySet()) {
            TFile moduleRoot = module.getKey();
            ModuleScanResults moduleScanResults = module.getValue();
            if (!moduleScanResults.hasNestedDeclarationFiles()) continue;
            nestedModuleDeclarations.putAll(this.declarationsReader.readNestedModuleDeclarationData(moduleScanResults.getNestedDeclarationFiles(), moduleRoot));
        }
        return nestedModuleDeclarations;
    }

    private void verifyModules(Map<TFile, ModuleScanResults> modules, Map<TFile, NestedModuleDeclarationData> nestedModuleDeclarations) throws MojoExecutionException {
        for (Map.Entry<TFile, ModuleScanResults> module : modules.entrySet()) {
            TFile moduleRoot = module.getKey();
            ModuleScanResults moduleScanResults = module.getValue();
            Set<String> moduleRelativeJsFiles = ArtifactPathUtils.getRelativePaths(moduleScanResults.getJavascriptFiles(), moduleRoot);
            if (nestedModuleDeclarations.containsKey(moduleRoot)) {
                NestedModuleDeclarationData nestedModuleData = nestedModuleDeclarations.get(moduleRoot);
                this.declarationsChecker.verifyExternalModule(moduleRoot, nestedModuleData, moduleRelativeJsFiles);
                continue;
            }
            Set<String> moduleRelativeDeclarations = this.declarationsReader.readRelativeDeclarations(moduleScanResults.getAssociationFiles(), moduleRoot);
            this.declarationsChecker.verifyModule(moduleRoot, moduleRelativeDeclarations, moduleRelativeJsFiles);
        }
    }
}

