/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.mapping;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.FeDeclarationReader;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.FeDeclarationWriter;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.FeManifestAssociationArbiter;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.FeManifestAssociationProcessor;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeDependencyDeclaration;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeDependencyDeclarationParameter;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeManifestAssociation;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeManifestAssociationParameter;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeManifestAssociationsConfiguration;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeOutputJsFileDeclaration;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.utils.DirectoryHelper;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.utils.JsonParser;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="report-fe-manifest-associations", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class ReportFeManifestAssociationsMojo
extends AbstractAmpsMojo {
    @Parameter
    private List<FeManifestAssociationParameter> feManifestAssociations;
    @Parameter
    private FeManifestAssociationsConfiguration feManifestAssociationsConfiguration = new FeManifestAssociationsConfiguration();
    @Parameter
    private List<FeDependencyDeclarationParameter> feExternalDependenciesDeclarations;
    @Parameter(property="skipReportFeManifestAssociations")
    private Boolean skipReportFeManifestAssociations;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (Boolean.TRUE.equals(this.skipReportFeManifestAssociations)) {
            this.getLog().info((CharSequence)"Skipping `report-fe-manifest-associations` execution");
            return;
        }
        MavenContext mavenContext = this.getMavenContext();
        DirectoryHelper directoryHelper = new DirectoryHelper(mavenContext);
        JsonParser jsonParser = new JsonParser();
        FeDeclarationReader reader = new FeDeclarationReader(directoryHelper, jsonParser);
        FeManifestAssociationProcessor processor = new FeManifestAssociationProcessor(directoryHelper, jsonParser);
        FeDeclarationWriter writer = new FeDeclarationWriter(directoryHelper, jsonParser);
        this.processManifestAssociations(reader, processor, writer, mavenContext, directoryHelper);
        this.processDependencyDeclarations(reader, writer);
    }

    private void processDependencyDeclarations(FeDeclarationReader reader, FeDeclarationWriter writer) throws MojoExecutionException {
        List<FeDependencyDeclaration> dependencyDeclarations = reader.getDependencyDeclarations(this.feExternalDependenciesDeclarations);
        if (dependencyDeclarations.isEmpty()) {
            this.getLog().info((CharSequence)"There were no frontend dependency declarations found. Skipping generating final mapping.");
            return;
        }
        writer.writeDependencyDeclarations(dependencyDeclarations);
    }

    private void processManifestAssociations(FeDeclarationReader reader, FeManifestAssociationProcessor processor, FeDeclarationWriter writer, MavenContext mavenContext, DirectoryHelper directoryHelper) throws MojoExecutionException {
        List<FeManifestAssociation> manifestAssociations = reader.getManifestAssociations(this.feManifestAssociations);
        if (manifestAssociations.isEmpty()) {
            this.getLog().info((CharSequence)"There were no frontend manifest associations found. Skipping generating final mapping.");
            return;
        }
        Map<String, FeOutputJsFileDeclaration> outputJsFileDeclarations = processor.transformManifestAssociationsToFileDeclarations(manifestAssociations);
        String packaging = mavenContext.getProject().getPackaging();
        if (packaging.equals("war")) {
            this.getLog().warn((CharSequence)"Cannot verify declared FE associations because the project specifies 'war' packaging. This is a limitation of the report-fe-manifest-associations mojo. To ensure correctness, verify fe-manifest-association.json exists in the output and declares all FE files.");
        } else {
            FeManifestAssociationArbiter arbiter = new FeManifestAssociationArbiter(directoryHelper, this.feManifestAssociationsConfiguration, this.getLog());
            arbiter.verifyOutput(outputJsFileDeclarations);
        }
        writer.writeManifestAssociation(outputJsFileDeclarations);
    }
}

