/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.database;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.database.AbstractDatabase;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@ParametersAreNonnullByDefault
public class MySQL
extends AbstractDatabase {
    private static final String DROP_DATABASE = "DROP DATABASE IF EXISTS `%s`;\n";
    private static final String DROP_USER = "GRANT USAGE ON *.* TO `%s`@localhost;\nDROP USER `%s`@localhost;\n";
    private static final String CREATE_DATABASE = "CREATE DATABASE `%s` CHARACTER SET utf8 COLLATE utf8_bin;\n";
    private static final String CREATE_USER = "CREATE USER `%s`@localhost IDENTIFIED BY '%s';\n";
    private static final String GRANT_PERMISSION = "GRANT ALL ON `%s`.* TO `%s`@localhost;\n";
    private static final String URL_PREFIX = "jdbc:mysql";

    public MySQL(Log log) {
        super(log, false, "mysql", "com.mysql.jdbc.Driver", URL_PREFIX);
    }

    @Override
    protected String dropDatabase(DataSource dataSource) throws MojoExecutionException {
        return String.format(DROP_DATABASE, this.getDatabaseName(dataSource));
    }

    @Override
    protected String dropUser(DataSource dataSource) {
        return String.format(DROP_USER, dataSource.getUsername(), dataSource.getUsername());
    }

    @Override
    protected String createDatabase(DataSource dataSource) throws MojoExecutionException {
        return String.format(CREATE_DATABASE, this.getDatabaseName(dataSource));
    }

    @Override
    protected String createUser(DataSource dataSource) {
        return String.format(CREATE_USER, dataSource.getUsername(), dataSource.getPassword());
    }

    @Override
    protected String grantPermissionForUser(DataSource dataSource) throws MojoExecutionException {
        return String.format(GRANT_PERMISSION, this.getDatabaseName(dataSource), dataSource.getUsername());
    }

    @Override
    protected String getDatabaseName(DataSource dataSource) throws MojoExecutionException {
        try {
            Class.forName(dataSource.getDriver());
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Could not load Mysql database library to classpath");
        }
        try {
            String jdbcUrl = dataSource.getUrl();
            DriverPropertyInfo[] driverProperties = DriverManager.getDriver(jdbcUrl).getPropertyInfo(jdbcUrl, null);
            if (driverProperties == null) {
                return null;
            }
            return Arrays.stream(driverProperties).filter(property -> "DBNAME".equalsIgnoreCase(property.name)).map(property -> property.value).findFirst().orElse(null);
        }
        catch (SQLException e) {
            throw new MojoExecutionException("");
        }
    }

    @Override
    @Nonnull
    public Xpp3Dom getSqlMavenCreateConfiguration(DataSource dataSource) throws MojoExecutionException {
        String sql = this.dropDatabase(dataSource) + this.dropUser(dataSource) + this.createDatabase(dataSource) + this.createUser(dataSource) + this.grantPermissionForUser(dataSource);
        this.log.info((CharSequence)("MySQL initialization database sql: " + sql));
        Xpp3Dom pluginConfiguration = this.systemDatabaseConfiguration(dataSource);
        pluginConfiguration.addChild(MojoExecutor.element(MojoExecutor.name("sqlCommand"), sql).toDom());
        return pluginConfiguration;
    }

    @Override
    public boolean isTypeOf(DataSource dataSource) {
        return super.isTypeOf(dataSource) || StringUtils.startsWith((CharSequence)dataSource.getUrl(), (CharSequence)URL_PREFIX) && this.usesNewDriver(dataSource);
    }

    private boolean usesNewDriver(DataSource dataSource) {
        return "com.mysql.cj.jdbc.Driver".equals(dataSource.getDriver());
    }
}

