/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.BannedArtifactsProvider;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.project.MavenProject;

class BannedArtifactsProviderImpl
implements BannedArtifactsProvider {
    private static final String ATLASSIAN_GROUP_ID_PREFIX = "com.atlassian";
    private static final Set<String> DISALLOWED_ARTIFACT_IDS = ImmutableSet.of((Object)"platform-public-api", (Object)"platform-deprecated-public-api");
    private static final Set<String> INTERNAL_ARTIFACT_IDS = ImmutableSet.of((Object)"platform-internal-api");
    @Component
    private MavenProject mavenProject;

    BannedArtifactsProviderImpl() {
    }

    @Override
    public Set<String> getBannedArtifacts(boolean forceInternal) {
        boolean internal;
        boolean bl = internal = forceInternal || this.isInternalPlugin();
        if (internal) {
            return DISALLOWED_ARTIFACT_IDS;
        }
        return BannedArtifactsProviderImpl.union(DISALLOWED_ARTIFACT_IDS, INTERNAL_ARTIFACT_IDS);
    }

    private boolean isInternalPlugin() {
        return this.mavenProject.getArtifact().getGroupId().startsWith(ATLASSIAN_GROUP_ID_PREFIX);
    }

    private static Set<String> union(Set<String> first, Set<String> second) {
        return Stream.concat(first.stream(), second.stream()).collect(Collectors.toSet());
    }
}

