package com.atlassian.maven.plugins.amps.xml;

import static com.atlassian.plugins.codegen.util.ClassnameUtil.camelCaseToDashed;

import java.util.HashMap;
import java.util.Map;

class IdProviderImpl implements IdProvider {
  private final Map<String, Integer> counts = new HashMap<>();

  @Override
  public String get(String className) {
    String baseId = camelCaseToDashed(className).toLowerCase();

    if (!counts.containsKey(baseId)) {
      counts.put(baseId, 0);
      return baseId;
    }

    Integer count = counts.get(baseId) + 1;
    counts.put(baseId, count);
    return String.format("%s_%d", baseId, count);
  }
}
