package com.atlassian.maven.plugins.amps.frontend.association.mapping.utils;

import com.atlassian.maven.plugins.amps.MavenContext;

import java.nio.file.Path;
import java.nio.file.Paths;

public class DirectoryHelper {

    public final static String ASSOCIATIONS_OUTPUT_DIR = "META-INF/fe-manifest-associations";
    public final static String WEB_RESOURCE_PLUGIN_CONFIGURATIONS_DIR = ASSOCIATIONS_OUTPUT_DIR;

    private final MavenContext mavenContext;

    public DirectoryHelper(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }

    public String getOutputFileAbsolutePath(String filepath) {
        return Paths.get(getOutputDirectoryPath(), filepath).toAbsolutePath().toString();
    }

    public String getOutputDirectoryPath() {
        return mavenContext.getProject().getBuild().getOutputDirectory();
    }

    public String getSourceFileAbsolutePath(String filepath) {
        Path path = Paths.get(filepath);
        Path outputPath = path.isAbsolute() ? path : Paths.get(getSourceDirectoryPath()).resolve(filepath);

        return outputPath.normalize().toString();
    }

    public String getSourceDirectoryPath() {
        return mavenContext.getProject().getBasedir().getAbsolutePath();
    }

    public String getPathRelativeToSourceDirectory(String filepath) {
        Path absolutePath = Paths.get(filepath);
        Path sourceDirectoryPath = Paths.get(getSourceDirectoryPath());

        if (!absolutePath.startsWith(sourceDirectoryPath)) {
            throw new RuntimeException("getPathRelativeToSourceDirectory: input path should be under the source directory " +
                sourceDirectoryPath + " but got " + filepath);
        }

        Path relativePath = sourceDirectoryPath.relativize(absolutePath);
        return relativePath.normalize().toString();
    }
}
