package com.atlassian.maven.plugins.amps;

import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Set;

class ValidateBannedDependenciesExecutor {
    private static final Logger logger =
            LoggerFactory.getLogger(ValidateBannedDependenciesExecutor.class);

    private final boolean skipBanningDependencies;
    private final Set<String> banningExcludes;
    private final String platformVersion;
    private final boolean forceInternalPlugin;
    private final boolean legacyValidateBannedDependencies;

    ValidateBannedDependenciesExecutor(
            boolean skipBanningDependencies,
            Set<String> banningExcludes,
            String platformVersion,
            boolean forceInternalPlugin,
            boolean legacyValidateBannedDependencies) {
        this.skipBanningDependencies = skipBanningDependencies;
        this.banningExcludes = banningExcludes;
        this.platformVersion = platformVersion;
        this.forceInternalPlugin = forceInternalPlugin;
        this.legacyValidateBannedDependencies = legacyValidateBannedDependencies;
    }

    void execute(MavenGoals mavenGoals) throws MojoExecutionException {
        if (legacyValidateBannedDependencies) {
            logger.warn("Property 'legacyValidateBannedDependencies' is depracated and will be removed in further versions");
        }

        if (skipBanningDependencies) {
            logger.warn("dependencies validation has been skipped");
            return;
        }

        mavenGoals.validateBannedDependencies(
                banningExcludes, platformVersion(), forceInternalPlugin, legacyValidateBannedDependencies);
    }

    private String platformVersion() throws MojoExecutionException {
        if (platformVersion != null) {
            return platformVersion;
        }

        return "[0,)";
    }
}
