package com.atlassian.maven.plugins.amps;

import com.google.common.collect.ImmutableSet;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.project.MavenProject;

import java.util.Set;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toSet;

class BannedArtifactsProviderImpl implements BannedArtifactsProvider {
    private final static String ATLASSIAN_GROUP_ID_PREFIX = "com.atlassian";
    private static final Set<String> DISALLOWED_ARTIFACT_IDS =
            ImmutableSet.of("platform-public-api", "platform-deprecated-public-api");
    private static final Set<String> INTERNAL_ARTIFACT_IDS = ImmutableSet.of("platform-internal-api");

    @Component
    private MavenProject mavenProject;

    @Override
    public Set<String> getBannedArtifacts(final boolean forceInternal) {
        boolean internal = forceInternal || isInternalPlugin();

        if (internal) {
            return DISALLOWED_ARTIFACT_IDS;
        }

        return union(DISALLOWED_ARTIFACT_IDS, INTERNAL_ARTIFACT_IDS);
    }

    private boolean isInternalPlugin() {
        return mavenProject.getArtifact().getGroupId().startsWith(ATLASSIAN_GROUP_ID_PREFIX);
    }

    private static Set<String> union(Set<String> first, Set<String> second) {
        return Stream.concat(first.stream(), second.stream()).collect(toSet());
    }
}
