/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Node;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractProductHandler;
import com.atlassian.maven.plugins.amps.product.PluginProvider;
import com.atlassian.maven.plugins.amps.product.manager.WebAppManager;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.repository.RepositorySystem;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class AbstractWebappProductHandler
extends AbstractProductHandler {
    private static final String CARGO_CONTAINER_ID_PROPERTY = "amps.product.specific.cargo.container";
    private static final String SPECIFIC_CONTAINER_PROPERTY = "amps.product.specific.container";
    private final WebAppManager webAppManager;

    protected AbstractWebappProductHandler(MavenContext context, MavenGoals goals, PluginProvider pluginProvider, RepositorySystem repositorySystem, ArtifactResolver artifactResolver, WebAppManager webAppManager) {
        super(context, goals, pluginProvider, repositorySystem, artifactResolver);
        this.webAppManager = Objects.requireNonNull(webAppManager);
    }

    @Override
    public final void stop(@Nonnull Product product) throws MojoExecutionException {
        this.webAppManager.stopWebapp(product, this.context);
    }

    @Override
    @Nonnull
    protected final File extractApplication(Product product) throws MojoExecutionException {
        ProductArtifact artifact = this.getArtifact(product);
        if ("RELEASE".equals(artifact.getVersion()) || "LATEST".equals(artifact.getVersion())) {
            this.setLatestStableVersion(product, artifact);
        }
        return this.goals.copyWebappWar(artifact, this.getBaseDirectory(product), product.getId());
    }

    @Override
    @Nonnull
    protected final List<Node> startProduct(Product product, File productFile, List<Map<String, String>> systemProperties) throws MojoExecutionException {
        return this.webAppManager.startWebapp(productFile, systemProperties, this.getExtraContainerDependencies(product, productFile), this.getExtraProductDeployables(product), product, this.context);
    }

    @Override
    protected boolean supportsStaticPlugins() {
        return true;
    }

    @Override
    @Nonnull
    protected Optional<String> getLog4jPropertiesPath() {
        return Optional.of("WEB-INF/classes/log4j.properties");
    }

    @Override
    @Nonnull
    protected Optional<String> getLog4j2ConfigPath() {
        return Optional.of("WEB-INF/classes/log4j2.xml");
    }

    @Nonnull
    protected List<ProductArtifact> getExtraContainerDependencies(Product product, File productFile) {
        return Collections.emptyList();
    }

    @Nonnull
    protected List<ProductArtifact> getExtraProductDeployables(Product product) {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    protected final Map<String, String> getSystemProperties(Product product, int nodeIndex) {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        systemProperties.putAll(this.generateJndiDataSourceSystemProperties(product));
        systemProperties.putAll(this.getProductSpecificSystemProperties(product, nodeIndex));
        return systemProperties;
    }

    @Nonnull
    protected abstract Map<String, String> getProductSpecificSystemProperties(Product var1, int var2);

    private Map<String, String> generateJndiDataSourceSystemProperties(Product product) {
        List<DataSource> dataSources = this.getJndiDataSources(product);
        if (dataSources.size() == 1) {
            return Collections.singletonMap("cargo.datasource.datasource", dataSources.get(0).getCargoString());
        }
        ImmutableMap.Builder systemProperties = ImmutableMap.builder();
        for (int i = 0; i < dataSources.size(); ++i) {
            systemProperties.put((Object)("cargo.datasource.datasource." + i), (Object)dataSources.get(i).getCargoString());
        }
        return systemProperties.build();
    }

    private List<DataSource> getJndiDataSources(Product product) {
        List<DataSource> dataSources = product.getDataSources();
        DataSource defaultDataSource = this.getDefaultDataSource(product);
        if (defaultDataSource != null) {
            if (dataSources.isEmpty()) {
                dataSources.add(defaultDataSource);
            } else {
                dataSources.get(0).copyMissingValuesFrom(defaultDataSource);
            }
        }
        return dataSources.stream().filter(ds -> StringUtils.isNotBlank((CharSequence)ds.getJndi())).collect(Collectors.toList());
    }

    @Nullable
    protected DataSource getDefaultDataSource(Product product) {
        return null;
    }

    @Override
    protected void addOverridesFromProductPom(Product product) throws MojoExecutionException {
        ProductArtifact artifact = this.getArtifact(product);
        File effectivePom = this.goals.generateEffectivePom(artifact, this.getBaseDirectory(product));
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(effectivePom.getAbsoluteFile());
            Element properties = document.getRootElement().element("properties");
            if (properties != null) {
                Element customContainer = properties.element(SPECIFIC_CONTAINER_PROPERTY);
                Element cargoId = properties.element(CARGO_CONTAINER_ID_PROPERTY);
                this.setPropertiesInProduct(product, customContainer, cargoId);
            }
        }
        catch (DocumentException e) {
            this.log.error((CharSequence)"Error when reading effective pom", (Throwable)e);
        }
    }

    private void setPropertiesInProduct(Product product, Element customContainer, Element cargoId) {
        if (customContainer != null && product.getCustomContainerArtifact() == null && product.isContainerNotSpecified()) {
            product.setCustomContainerArtifact(customContainer.getStringValue());
            if (cargoId != null) {
                product.setContainerId(cargoId.getStringValue());
            }
        }
    }
}

