/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.pdk;

import com.atlassian.maven.plugins.amps.AbstractProductAwareMojo;
import com.atlassian.maven.plugins.amps.PdkParams;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractInstallPluginMojo
extends AbstractProductAwareMojo {
    @Parameter(property="atlassian.plugin.key")
    private String pluginKey;
    @Parameter(property="project.groupId")
    private String groupId;
    @Parameter(property="project.artifactId")
    private String artifactId;
    @Parameter(property="http.port")
    private int httpPort;
    @Parameter(property="context.path")
    private String contextPath;
    @Parameter(property="username", defaultValue="admin")
    private String username;
    @Parameter(property="password", defaultValue="admin")
    private String password;
    @Parameter(property="server", defaultValue="localhost")
    private String server;

    protected final void installPlugin(boolean isTestPlugin) throws MojoExecutionException {
        this.ensurePluginKeyExists();
        ProductHandler productHandler = this.getProductHandler(this.getProductId());
        this.getMavenGoals().installPlugin(new PdkParams.Builder().testPlugin(isTestPlugin).pluginKey(this.pluginKey).server(this.server).port(this.getPort(this.server, productHandler)).contextPath(this.getContextPath(productHandler)).username(this.username).password(this.password).build());
    }

    private void ensurePluginKeyExists() {
        if (this.pluginKey == null) {
            this.pluginKey = this.groupId + "." + this.artifactId;
        }
    }

    private int getPort(String server, ProductHandler handler) {
        if (this.httpPort != 0) {
            return this.httpPort;
        }
        return server.startsWith("https://") ? handler.getDefaultHttpsPort() : handler.getDefaultHttpPort();
    }

    private String getContextPath(ProductHandler handler) {
        return this.contextPath == null ? "/" + handler.getId() : this.contextPath;
    }
}

