/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.verification.utils;

import de.schlichtherle.truezip.file.TFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class ArtifactPathUtils {
    public static Set<String> getRelativePaths(Collection<TFile> files, TFile moduleRoot) {
        return files.stream().map(file -> ArtifactPathUtils.getRelativePath(file, moduleRoot)).collect(Collectors.toSet());
    }

    public static String getRelativePath(TFile file, TFile moduleRoot) {
        String systemNormalizedPath = FilenameUtils.separatorsToSystem((String)file.getPath());
        Path normalizedPath = Paths.get(systemNormalizedPath, new String[0]).normalize();
        return Paths.get(moduleRoot.getPath(), new String[0]).relativize(normalizedPath).toString();
    }
}

