/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.mapping;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.FeManifestAssociationArbiter;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.FeManifestAssociationProcessor;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.FeManifestAssociationReader;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.FeManifestAssociationWriter;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeManifestAssociation;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeManifestAssociationParameter;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeManifestAssociationsConfiguration;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeOutputJsFileDeclaration;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.utils.DirectoryHelper;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.utils.JsonParser;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="report-fe-manifest-associations", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class ReportFeManifestAssociationsMojo
extends AbstractAmpsMojo {
    @Parameter
    private List<FeManifestAssociationParameter> feManifestAssociations;
    @Parameter
    private FeManifestAssociationsConfiguration feManifestAssociationsConfiguration = new FeManifestAssociationsConfiguration();
    @Parameter(property="skipReportFeManifestAssociations")
    private Boolean skipReportFeManifestAssociations;

    public void execute() throws MojoExecutionException, MojoFailureException {
        JsonParser jsonParser;
        if (Boolean.TRUE.equals(this.skipReportFeManifestAssociations)) {
            this.getLog().info((CharSequence)"Skipping `report-fe-manifest-associations` execution");
            return;
        }
        MavenContext mavenContext = this.getMavenContext();
        DirectoryHelper directoryHelper = new DirectoryHelper(mavenContext);
        FeManifestAssociationReader reader = new FeManifestAssociationReader(directoryHelper, jsonParser = new JsonParser());
        List<FeManifestAssociation> manifestAssociations = reader.getManifestAssociations(this.feManifestAssociations);
        if (manifestAssociations.isEmpty()) {
            this.getLog().info((CharSequence)"There were no frontend manifest associations found. Skipping generating final mapping.");
            return;
        }
        FeManifestAssociationProcessor processor = new FeManifestAssociationProcessor(directoryHelper, jsonParser);
        Map<String, FeOutputJsFileDeclaration> outputJsFileDeclarations = processor.transformManifestAssociationsToFileDeclarations(manifestAssociations);
        String packaging = mavenContext.getProject().getPackaging();
        if (packaging.equals("war")) {
            this.getLog().warn((CharSequence)"Cannot verify declared FE associations because the project specifies 'war' packaging. This is a limitation of the report-fe-manifest-associations mojo. To ensure correctness, verify fe-manifest-association.json exists in the output and declares all FE files.");
        } else {
            FeManifestAssociationArbiter arbiter = new FeManifestAssociationArbiter(directoryHelper, this.feManifestAssociationsConfiguration, this.getLog());
            arbiter.verifyOutput(outputJsFileDeclarations);
        }
        FeManifestAssociationWriter writer = new FeManifestAssociationWriter(directoryHelper, jsonParser);
        writer.writeManifestAssociation(outputJsFileDeclarations);
    }
}

