/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.mapping;

import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeOutputJsFileDeclaration;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.utils.DirectoryHelper;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.utils.JsonParser;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;

public class FeManifestAssociationWriter {
    private final DirectoryHelper directoryHelper;
    private final JsonParser jsonParser;

    public FeManifestAssociationWriter(DirectoryHelper directoryHelper, JsonParser jsonParser) {
        this.directoryHelper = directoryHelper;
        this.jsonParser = jsonParser;
    }

    public void writeManifestAssociation(Map<String, FeOutputJsFileDeclaration> outputJsFileDeclarations) throws MojoExecutionException {
        File outputDirectory = this.createOutputDirectory();
        File outputFile = new File(outputDirectory, "fe-manifest-association.json");
        try {
            this.jsonParser.writeFile(outputFile, outputJsFileDeclarations);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Couldn't write final association mapping.");
        }
    }

    @Nonnull
    private File createOutputDirectory() throws MojoExecutionException {
        String outputDirectoryPath = this.directoryHelper.getOutputFileAbsolutePath("META-INF/fe-manifest-associations");
        File outputDirectory = new File(outputDirectoryPath);
        if (outputDirectory.exists() || outputDirectory.mkdirs()) {
            return outputDirectory;
        }
        throw new MojoExecutionException("Output directory for frontend manifest association mapping couldn't be created");
    }
}

