package com.atlassian.maven.plugins.amps.frontend.association.verification.utils;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.archive.zip.JarDriver;
import de.schlichtherle.truezip.socket.sl.IOPoolLocator;
import org.apache.maven.plugin.MojoExecutionException;

public class TrueZipUtils {

    public static void configureTrueZip() {
        TConfig.get().setArchiveDetector(new TArchiveDetector(TArchiveDetector.ALL, new Object[][]{
            {"obr", new JarDriver(IOPoolLocator.SINGLETON)}
        }));
    }

    public static void unmountTrueZip() throws MojoExecutionException {
        try {
            TVFS.umount();
        } catch (FsSyncException e) {
            throw new MojoExecutionException(e);
        }
    }
}
