package com.atlassian.maven.plugins.amps.frontend.association.verification.utils;

import de.schlichtherle.truezip.file.TFile;
import org.apache.commons.io.FilenameUtils;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class ArtifactPathUtils {
    public static Set<String> getRelativePaths(Collection<TFile> files, TFile moduleRoot) {
        return files.stream()
            .map(file -> getRelativePath(file, moduleRoot))
            .collect(Collectors.toSet());
    }

    public static String getRelativePath(TFile file, TFile moduleRoot) {
        String systemNormalizedPath = FilenameUtils.separatorsToSystem(file.getPath());
        Path normalizedPath = Paths.get(systemNormalizedPath).normalize();
        return Paths.get(moduleRoot.getPath()).relativize(normalizedPath).toString();
    }
}
