package com.atlassian.maven.plugins.amps.frontend.association.verification.impl;

import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeOutputJsFileDeclaration;
import com.atlassian.maven.plugins.amps.frontend.association.verification.DeclarationsReader;
import com.atlassian.maven.plugins.amps.frontend.association.verification.utils.ArtifactPathUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileReader;
import org.apache.maven.plugin.MojoExecutionException;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.atlassian.maven.plugins.amps.frontend.association.FeManifestAssociationConstants.JAVASCRIPT_FILE_REGEX;

public class DeclarationsReaderImpl implements DeclarationsReader {
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public Set<String> readRelativeDeclarations(Collection<TFile> associationFiles, TFile moduleRoot) throws MojoExecutionException {
        Set<TFile> declaredFiles = readDeclarations(associationFiles)
            .stream().map(relativePath -> new TFile(moduleRoot, relativePath))
            .collect(Collectors.toSet());

        return ArtifactPathUtils.getRelativePaths(declaredFiles, moduleRoot);
    }

    private Set<String> readDeclarations(Collection<TFile> associationFiles) throws MojoExecutionException {
        Set<String> declaredFiles = new HashSet<>();

        for (TFile file : associationFiles) {
            Map<String, FeOutputJsFileDeclaration> associations = readAssociationFile(file);
            Set<String> declarations = associations.keySet();
            Set<String> jsDeclarations = declarations
                .stream().filter(path -> path.matches(JAVASCRIPT_FILE_REGEX))
                .collect(Collectors.toSet());
            declaredFiles.addAll(jsDeclarations);
        }

        return declaredFiles;
    }

    private Map<String, FeOutputJsFileDeclaration> readAssociationFile(TFile file) throws MojoExecutionException {
        try {
            Reader reader = new TFileReader(file);
            return objectMapper.readValue(reader, new TypeReference<Map<String, FeOutputJsFileDeclaration>>() {
            });
        } catch (IOException e) {
            throw new MojoExecutionException("Error reading:\n" + file + "\n" + e);
        }
    }
}
