package com.atlassian.maven.plugins.amps.frontend.association.mapping;

import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeOutputJsFileDeclaration;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.utils.DirectoryHelper;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.utils.JsonParser;
import org.apache.maven.plugin.MojoExecutionException;

import javax.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.util.Map;

import static com.atlassian.maven.plugins.amps.frontend.association.FeManifestAssociationConstants.FINAL_ASSOCIATION_MAPPING_FILE;
import static com.atlassian.maven.plugins.amps.frontend.association.mapping.utils.DirectoryHelper.ASSOCIATIONS_OUTPUT_DIR;

public class FeManifestAssociationWriter {

    private final DirectoryHelper directoryHelper;
    private final JsonParser jsonParser;

    public FeManifestAssociationWriter(DirectoryHelper directoryHelper, JsonParser jsonParser) {
        this.directoryHelper = directoryHelper;
        this.jsonParser = jsonParser;
    }

    public void writeManifestAssociation(Map<String, FeOutputJsFileDeclaration> outputJsFileDeclarations) throws MojoExecutionException {
        File outputDirectory = createOutputDirectory();
        File outputFile = new File(outputDirectory, FINAL_ASSOCIATION_MAPPING_FILE);

        try {
            jsonParser.writeFile(outputFile, outputJsFileDeclarations);
        } catch (IOException e) {
            throw new MojoExecutionException("Couldn't write final association mapping.");
        }
    }

    @Nonnull
    private File createOutputDirectory() throws MojoExecutionException {
        String outputDirectoryPath = directoryHelper.getOutputFileAbsolutePath(ASSOCIATIONS_OUTPUT_DIR);
        final File outputDirectory = new File(outputDirectoryPath);
        if (outputDirectory.exists() || outputDirectory.mkdirs()) {
            return outputDirectory;
        }

        throw new MojoExecutionException("Output directory for frontend manifest association mapping couldn't be created");
    }

}
