/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.manager;

import com.atlassian.maven.plugins.amps.product.manager.Container;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class Containers {
    private static final String TOMCAT_GROUP_ID = "org.apache.tomcat";
    private static final String TOMCAT_ARTIFACT_ID = "apache-tomcat";
    private static final String TOMCAT_8_X = "tomcat8x";
    private static final String WINDOWS_X_64 = "windows-x64";
    private static final Map<String, Container> CONTAINERS_BY_ID = ImmutableMap.builder().put((Object)"tomcat5x", (Object)new Container("tomcat5x", "org.apache.tomcat", "apache-tomcat", "5.5.36")).put((Object)"tomcat6x", (Object)new Container("tomcat6x", "org.apache.tomcat", "apache-tomcat", "6.0.41")).put((Object)"tomcat7x", (Object)new Container("tomcat7x", "org.apache.tomcat", "apache-tomcat", "7.0.73-atlassian-hosted", "windows-x64")).put((Object)"tomcat8x", (Object)new Container("tomcat8x", "org.apache.tomcat", "apache-tomcat", "8.0.53-atlassian-hosted", "windows-x64")).put((Object)"tomcat85x", (Object)new Container("tomcat8x", "org.apache.tomcat", "apache-tomcat", "8.5.40-atlassian-hosted", "windows-x64")).put((Object)"tomcat85_6", (Object)new Container("tomcat8x", "org.apache.tomcat", "apache-tomcat", "8.5.6-atlassian-hosted", "windows-x64")).put((Object)"tomcat85_29", (Object)new Container("tomcat8x", "org.apache.tomcat", "apache-tomcat", "8.5.29-atlassian-hosted", "windows-x64")).put((Object)"tomcat85_32", (Object)new Container("tomcat8x", "org.apache.tomcat", "apache-tomcat", "8.5.32-atlassian-hosted", "windows-x64")).put((Object)"tomcat85_35", (Object)new Container("tomcat8x", "org.apache.tomcat", "apache-tomcat", "8.5.35-atlassian-hosted", "windows-x64")).put((Object)"tomcat9x", (Object)new Container("tomcat9x", "org.apache.tomcat", "apache-tomcat", "9.0.11-atlassian-hosted", "windows-x64")).put((Object)"jetty6x", (Object)new Container("jetty6x")).put((Object)"jetty7x", (Object)new Container("jetty7x")).put((Object)"jetty8x", (Object)new Container("jetty8x")).put((Object)"jetty9x", (Object)new Container("jetty9x")).build();

    public static Container findContainer(String containerId) {
        Container container = CONTAINERS_BY_ID.get(containerId);
        if (container == null) {
            throw new IllegalArgumentException("Container " + containerId + " not supported");
        }
        return container;
    }

    private Containers() {
    }
}

