/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira.config;

import com.atlassian.maven.plugins.amps.database.DatabaseType;
import com.atlassian.maven.plugins.amps.product.common.XMLDocumentTransformer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Node;

@ParametersAreNonnullByDefault
public class DatabaseTypeUpdaterTransformer
implements XMLDocumentTransformer {
    private final DatabaseType dbType;

    public DatabaseTypeUpdaterTransformer(DatabaseType dbType) {
        this.dbType = dbType;
    }

    @Override
    public boolean transform(Document document) {
        String currentDbType;
        Node dbTypeNode = document.selectSingleNode("/jira-database-config/database-type");
        if (dbTypeNode != null && StringUtils.isNotEmpty((CharSequence)dbTypeNode.getStringValue()) && !(currentDbType = dbTypeNode.getStringValue()).equals(this.dbType.getOfBizName())) {
            dbTypeNode.setText(this.dbType.getOfBizName());
            return true;
        }
        return false;
    }
}

