/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Node;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.atlassian.maven.plugins.amps.util.ZipUtils;
import com.atlassian.maven.plugins.amps.util.ant.AntJavaExecutorThread;
import com.atlassian.maven.plugins.amps.util.ant.JavaTaskFactory;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.tools.ant.taskdefs.Java;

@ParametersAreNonnullByDefault
public class CtkServerProductHandler
implements ProductHandler {
    private static final String CTK_SERVER_ARTIFACT_MATCHER = "federated-api-ctk-server-.*\\.jar";
    private final MavenContext context;
    private final MavenGoals goals;
    private final JavaTaskFactory javaTaskFactory;
    private final Log log;

    public CtkServerProductHandler(MavenContext context, MavenGoals goals) {
        this.context = context;
        this.goals = goals;
        this.javaTaskFactory = new JavaTaskFactory(context.getLog());
        this.log = context.getLog();
    }

    @Override
    @Nonnull
    public String getId() {
        return "ctk-server";
    }

    @Override
    public int getDefaultHttpPort() {
        return 8990;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 8448;
    }

    @Override
    @Nonnull
    public ProductArtifact getArtifact() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @Nonnull
    public Optional<ProductArtifact> getTestResourcesArtifact() {
        return Optional.empty();
    }

    @Override
    @Nonnull
    public String getDefaultContextPath() {
        return "/";
    }

    @Override
    @Nonnull
    public List<Node> start(Product product) throws MojoExecutionException {
        this.unpackContainer(product);
        return this.startContainer(product);
    }

    @Override
    public void stop(Product product) throws MojoExecutionException {
        try {
            this.stopContainer(product);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to send stop command to CTK server", (Exception)e);
        }
    }

    @Override
    @Nonnull
    public String getDefaultContainerId() {
        return "ctk-server";
    }

    @Override
    @Nonnull
    public String getDefaultContainerId(Product product) {
        return this.getDefaultContainerId();
    }

    @Override
    @Nonnull
    public List<File> getSnapshotDirectories(@Nonnull Product product) {
        return Collections.singletonList(this.getBaseDirectory(product));
    }

    @Override
    @Nonnull
    public List<File> getHomeDirectories(@Nonnull Product product) {
        return Collections.singletonList(this.getBaseDirectory(product));
    }

    @Override
    @Nonnull
    public File getBaseDirectory(@Nonnull Product product) {
        return ProjectUtils.createDirectory(new File(this.context.getProject().getBuild().getDirectory(), "ctk-server-" + product.getVersion()));
    }

    @Override
    public void createHomeZip(@Nonnull File homeDirectory, @Nonnull File targetZip, @Nonnull Product product) {
        throw new UnsupportedOperationException();
    }

    private void unpackContainer(Product product) throws MojoExecutionException {
        File baseDirectory = this.getBaseDirectory(product);
        String[] directoryContents = baseDirectory.list();
        if (directoryContents == null || directoryContents.length == 0) {
            File serverDistributionArtifactFile = this.copyServerArtifactToOutputDirectory(product);
            this.unpackServerArtifact(serverDistributionArtifactFile, baseDirectory);
            this.deleteServerArtifact(serverDistributionArtifactFile);
        } else {
            this.log.debug((CharSequence)("CTK Server " + product.getVersion() + " already unpacked."));
        }
    }

    private File copyServerArtifactToOutputDirectory(Product product) throws MojoExecutionException {
        File buildDirectory = new File(this.context.getProject().getBuild().getDirectory());
        ProductArtifact artifact = this.getServerDistributionArtifact(product);
        String filename = String.format("%s-%s.%s", artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
        return this.goals.copyZip(buildDirectory, artifact, filename);
    }

    private void unpackServerArtifact(File serverDistributionArtifactFile, File serverDirectory) throws MojoExecutionException {
        try {
            ZipUtils.unzip(serverDistributionArtifactFile, serverDirectory.getPath(), 0);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to extract CTK server distribution: " + serverDistributionArtifactFile, (Exception)ex);
        }
    }

    private void deleteServerArtifact(File artifactFile) {
        this.log.debug((CharSequence)("Deleting CTK server distribution artifact: " + artifactFile.getPath()));
        if (!artifactFile.delete()) {
            this.log.warn((CharSequence)("Failed to delete CTK server distribution artifact: " + artifactFile.getPath()));
        }
    }

    private List<Node> startContainer(Product product) {
        Map<String, String> systemProperties = this.getSystemProperties(product);
        Java java = this.javaTaskFactory.newJavaTask(JavaTaskFactory.output(product.getOutput()).systemProperties(systemProperties).jvmArgs(product.getJvmArgs() + product.getSingleNodeDebugArgs()));
        java.setDir(this.getBaseDirectory(product));
        java.setJar(this.findServerJar(product));
        java.createArg().setValue("--host");
        java.createArg().setValue(product.getServer());
        java.createArg().setValue("--port");
        java.createArg().setValue(Integer.toString(product.getSingleNodeWebPort()));
        AntJavaExecutorThread javaThread = new AntJavaExecutorThread(java);
        javaThread.start();
        return product.getNodes();
    }

    private ProductArtifact getServerDistributionArtifact(Product product) {
        return new ProductArtifact("com.atlassian.federation", "federated-api-ctk-server-distribution", product.getVersion(), "zip");
    }

    private Map<String, String> getSystemProperties(Product product) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : product.getSystemPropertyVariables().entrySet()) {
            map.put(entry.getKey(), (String)entry.getValue());
        }
        return map;
    }

    private File findServerJar(Product product) {
        File baseDirectory = this.getBaseDirectory(product);
        Object[] files = baseDirectory.listFiles((dir, name) -> name.matches(CTK_SERVER_ARTIFACT_MATCHER));
        if (files == null || files.length == 0) {
            throw new IllegalStateException("CTK Server JAR file not found in: " + baseDirectory + " (expected a file matching " + CTK_SERVER_ARTIFACT_MATCHER + ")");
        }
        if (files.length == 1) {
            return files[0];
        }
        throw new IllegalStateException("Found too many CTK Server JAR files, expected only one: " + Arrays.toString(files));
    }

    private void stopContainer(Product product) throws IOException, MojoExecutionException {
        URL url = new URL(product.getProtocol(), product.getServer(), product.getSingleNodeWebPort(), product.getContextPath());
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        httpConnection.setConnectTimeout(product.getShutdownTimeout());
        httpConnection.setRequestMethod("DELETE");
        int responseCode = httpConnection.getResponseCode();
        if (responseCode != 200) {
            throw new MojoExecutionException("CTK server didn't understand stop command; received HTTP response code: " + responseCode);
        }
    }
}

