/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.product.manager.WebAppManager;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.repository.RepositorySystem;

public class CrowdProductHandler
extends AbstractWebappProductHandler {
    private static final String LOCAL_CROWD_CONFIG = "crowd.cfg.xml";
    private static final String SHARED_CROWD_CONFIG = "shared/crowd.cfg.xml";

    public CrowdProductHandler(MavenContext context, MavenGoals goals, RepositorySystem repositorySystem, ArtifactResolver artifactResolver, WebAppManager webAppManager) {
        super(context, goals, new CrowdPluginProvider(), repositorySystem, artifactResolver, webAppManager);
    }

    @Override
    @Nonnull
    public String getId() {
        return "crowd";
    }

    @Override
    @Nonnull
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.crowd", "crowd-web-app", "RELEASE");
    }

    @Override
    @Nonnull
    public Optional<ProductArtifact> getTestResourcesArtifact() {
        return Optional.of(new ProductArtifact("com.atlassian.crowd.distribution", "crowd-plugin-test-resources"));
    }

    @Override
    public int getDefaultHttpPort() {
        return 4990;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 8444;
    }

    @Override
    @Nonnull
    protected Map<String, String> getProductSpecificSystemProperties(Product product, int nodeIndex) {
        ImmutableMap.Builder systemProperties = ImmutableMap.builder();
        systemProperties.put((Object)"cargo.servlet.uriencoding", (Object)"UTF-8");
        List<File> homeDirectories = this.getHomeDirectories(product);
        File sharedHome = new File(homeDirectories.get(0), "shared");
        String homeDirectory = homeDirectories.get(nodeIndex).getPath();
        systemProperties.put((Object)"crowd.home", (Object)homeDirectory);
        systemProperties.put((Object)"crowd.shared.home", (Object)sharedHome.getPath());
        systemProperties.put((Object)"cluster.node.name", (Object)(product.getInstanceId() + "-" + nodeIndex));
        return systemProperties.build();
    }

    @Override
    @Nonnull
    public Optional<File> getUserInstalledPluginsDirectory(Product product, File webappDir, File homeDir) {
        File sharedHomeDir = new File(homeDir, "shared");
        if (sharedHomeDir.exists()) {
            return Optional.of(new File(sharedHomeDir, "plugins"));
        }
        return Optional.of(new File(homeDir, "plugins"));
    }

    @Override
    @Nonnull
    public List<ProductArtifact> getExtraContainerDependencies(Product product, File productFile) {
        return Arrays.asList(new ProductArtifact("hsqldb", "hsqldb", "1.8.0.7"), new ProductArtifact("javax.transaction", "jta", "1.1"), new ProductArtifact("javax.mail", "mail", "1.4"), new ProductArtifact("javax.activation", "activation", "1.0.2"));
    }

    @Override
    @Nonnull
    protected Collection<String> getExtraJarsToSkipWhenScanningForTldsAndWebFragments() {
        return Collections.singleton("mail-*.jar");
    }

    @Override
    @Nonnull
    public File getBundledPluginPath(Product product, File productDir) {
        return new File(productDir, "WEB-INF/classes/atlassian-bundled-plugins.zip");
    }

    @Override
    public void processHomeDirectory(Product product, int nodeIndex, File homeDir) throws MojoExecutionException {
        super.processHomeDirectory(product, nodeIndex, homeDir);
        try {
            this.updateLicenseInSharedConfig(homeDir, product);
            this.updateClusteringEnabledFlag(homeDir, product);
            this.updateHsqlUrlInCrowdConfig(homeDir);
            this.updateCrowdDotProperties(product, nodeIndex, homeDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    @Override
    protected boolean useBackdoorToInstallLicense() {
        return false;
    }

    private void updateLicenseInSharedConfig(File homeDir, Product product) throws MojoExecutionException {
        Optional<String> license = product.getUserConfiguredLicense();
        if (license.isPresent()) {
            ConfigFileUtils.replaceAll(new File(homeDir, SHARED_CROWD_CONFIG), "(<property name=\"license\">).+(</property>)", "$1" + license.get() + "$2");
        }
    }

    private void updateClusteringEnabledFlag(File homeDir, Product product) throws MojoExecutionException {
        if (product.isMultiNode()) {
            ConfigFileUtils.replaceAll(new File(homeDir, SHARED_CROWD_CONFIG), "crowd.clustering.enabled\">false<", "crowd.clustering.enabled\">true<");
        }
    }

    private void updateHsqlUrlInCrowdConfig(File homeDir) throws IOException, MojoExecutionException {
        String jdbcDir = homeDir.getCanonicalPath().replace("\\", "/");
        String hsqldbUrl = "jdbc:hsqldb:" + jdbcDir + "/database/defaultdb";
        ConfigFileUtils.replaceAll(new File(homeDir, SHARED_CROWD_CONFIG), "jdbc:hsqldb:.*/(crowd-)?home/database/defaultdb", hsqldbUrl);
        ConfigFileUtils.replaceAll(new File(homeDir, LOCAL_CROWD_CONFIG), "jdbc:hsqldb:.*/(crowd-)?home/database/defaultdb", hsqldbUrl);
    }

    private void updateCrowdDotProperties(Product product, int nodeIndex, File homeDir) throws MojoExecutionException {
        String baseUrl = this.getBaseUrl(product, nodeIndex);
        ImmutableMap newProperties = ImmutableMap.of((Object)"crowd.server.url", (Object)(baseUrl + "/services"), (Object)"application.login.url", (Object)baseUrl);
        ConfigFileUtils.updateProperties(new File(homeDir, "crowd.properties"), (Map<String, String>)newProperties);
    }

    private String getBaseUrl(Product product, int nodeIndex) throws MojoExecutionException {
        try {
            return CrowdProductHandler.withLocalhostAsHostname(product.getBaseUrlForNode(nodeIndex));
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Unable to process Crowd service URL", (Exception)e);
        }
    }

    static String withLocalhostAsHostname(@Nonnull String uri) throws URISyntaxException {
        URI base = new URI(uri);
        URI baseWithLocalhost = new URI(base.getScheme(), base.getUserInfo(), "localhost", base.getPort(), base.getPath(), base.getQuery(), base.getFragment());
        return baseWithLocalhost.toString();
    }

    @Override
    protected void cleanupProductHomeForZip(@Nonnull Product product, @Nonnull File homeDirectory) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, homeDirectory);
        FileUtils.deleteQuietly((File)new File(homeDirectory, "caches"));
        FileUtils.deleteQuietly((File)new File(homeDirectory, "logs"));
    }

    @Override
    @Nonnull
    protected List<File> getConfigFiles(@Nonnull Product product, @Nonnull File snapshotDir) {
        List<File> configFiles = super.getConfigFiles(product, snapshotDir);
        configFiles.add(new File(snapshotDir, "database.log"));
        configFiles.add(new File(snapshotDir, LOCAL_CROWD_CONFIG));
        configFiles.add(new File(snapshotDir, SHARED_CROWD_CONFIG));
        configFiles.add(new File(snapshotDir, "crowd.properties"));
        return configFiles;
    }

    private static class CrowdPluginProvider
    extends AbstractPluginProvider {
        private CrowdPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-crowd-plugin", salVersion));
        }

        @Override
        protected Collection<ProductArtifact> getPdkInstallArtifacts(String pdkInstallVersion) {
            ArrayList<ProductArtifact> plugins = new ArrayList<ProductArtifact>(super.getPdkInstallArtifacts(pdkInstallVersion));
            plugins.add(new ProductArtifact("commons-fileupload", "commons-fileupload", "1.2.1"));
            return plugins;
        }
    }
}

