/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.minifier;

import com.google.common.collect.ImmutableMap;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.logging.Log;

public class MinifierParameters {
    private final boolean compressJs;
    private final boolean compressCss;
    private final Charset cs;
    private final Log log;
    private final Map<String, String> closureOptions;
    private final boolean closureJsdocWarningsEnabled;
    private boolean useClosureForJs = true;

    public MinifierParameters(boolean compressJs, boolean compressCss, Charset cs, Log log, @Nullable Map<String, String> closureOptions, boolean closureJsdocWarningsEnabled) {
        this.compressJs = compressJs;
        this.compressCss = compressCss;
        this.cs = cs;
        this.log = log;
        ImmutableMap.Builder opts = ImmutableMap.builder();
        opts.put((Object)"outputCharset", (Object)cs.name());
        if (closureOptions != null) {
            opts.putAll(closureOptions);
        }
        this.closureOptions = opts.build();
        this.closureJsdocWarningsEnabled = closureJsdocWarningsEnabled;
    }

    @Deprecated
    public MinifierParameters(boolean compressJs, boolean compressCss, boolean useClosureForJs, boolean closureJsdocWarningsEnabled, Charset cs, Log log, Map<String, String> closureOptions) {
        this(compressJs, compressCss, cs, log, closureOptions, closureJsdocWarningsEnabled);
        this.useClosureForJs = useClosureForJs;
    }

    public boolean isCompressJs() {
        return this.compressJs;
    }

    public boolean isCompressCss() {
        return this.compressCss;
    }

    @Deprecated
    public boolean isUseClosureForJs() {
        return this.useClosureForJs;
    }

    public Charset getCs() {
        return this.cs;
    }

    public Log getLog() {
        return this.log;
    }

    @Nonnull
    public Map<String, String> getClosureOptions() {
        return this.closureOptions;
    }

    public boolean isClosureJsdocWarningsEnabled() {
        return this.closureJsdocWarningsEnabled;
    }
}

