/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.i18n;

import com.atlassian.maven.plugins.amps.i18n.I18nScanner;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

class FindI18nUsageInSoy
implements I18nScanner {
    private static final String I18N_KEY_GROUP = "i18nKey";
    private static final Pattern SOY_PATTERN = Pattern.compile("\\{[^\\}]*?getText\\s*\\(\\s*(['\"])(?<i18nKey>[\\w.-]+)\\1\\s*[\\),]");

    FindI18nUsageInSoy() {
    }

    @Override
    @Nonnull
    public List<String> findI18nUsages(@Nonnull File file) {
        return FileUtils.readFileToString(file, StandardCharsets.UTF_8).map(input -> {
            ArrayList<String> foundInstances = new ArrayList<String>();
            Matcher matcher = SOY_PATTERN.matcher((CharSequence)input);
            while (matcher.find()) {
                foundInstances.add(matcher.group(I18N_KEY_GROUP));
            }
            return foundInstances;
        }).orElse(Collections.emptyList());
    }
}

