/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.Node;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.TestGroup;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractTestGroupsHandlerMojo
extends AbstractProductHandlerMojo {
    private static final String PORT_CONFLICT_MESSAGE_FORMAT = "%s (node %d): The configured %s port, %d, is in use by the %s port for %s (node %d)";
    @Parameter(property="testGroup")
    private String testGroup;
    @VisibleForTesting
    @Parameter
    List<TestGroup> testGroups = new ArrayList<TestGroup>();

    protected final List<TestGroup> getTestGroups() {
        return this.testGroups;
    }

    protected List<Product> getProductsForTestGroup(String testGroupId) throws MojoExecutionException {
        ArrayList<Product> products = new ArrayList<Product>();
        int dupCounter = 0;
        HashSet<String> uniqueProductIds = new HashSet<String>();
        Map<String, Product> productContexts = this.getProductContexts();
        for (String instanceId : this.getTestGroupInstanceIds(testGroupId)) {
            Product product = productContexts.get(instanceId);
            if (product == null) {
                throw new MojoExecutionException("The test group '" + testGroupId + "' refers to a product '" + instanceId + "' that doesn't have an associated <product> configuration.");
            }
            if (uniqueProductIds.contains(instanceId)) {
                product.setInstanceId(instanceId + "-" + dupCounter++);
            } else {
                uniqueProductIds.add(instanceId);
            }
            products.add(product);
        }
        if (products.size() > 1) {
            this.validatePortConfiguration(products);
        }
        return products;
    }

    private List<String> getTestGroupInstanceIds(String testGroupId) throws MojoExecutionException {
        ArrayList<String> instanceIds = new ArrayList<String>();
        if ("__no_test_group__".equals(testGroupId)) {
            instanceIds.add(this.getProductId());
        }
        for (TestGroup group : this.testGroups) {
            if (!StringUtils.equals((CharSequence)group.getId(), (CharSequence)testGroupId)) continue;
            instanceIds.addAll(group.getInstanceIds());
        }
        if (ProductHandlerFactory.getIds().contains(testGroupId) && !instanceIds.contains(testGroupId)) {
            instanceIds.add(testGroupId);
        }
        if (instanceIds.isEmpty()) {
            this.getLog().warn((CharSequence)("Unknown test group ID: " + testGroupId + " Detected IDs: " + this.getTestGroupIds()));
        }
        return instanceIds;
    }

    protected final Set<String> getTestGroupIds() {
        return this.testGroups.stream().map(TestGroup::getId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected final List<Product> getProductsToExecute() throws MojoExecutionException {
        if (StringUtils.isNotBlank((CharSequence)this.testGroup)) {
            return this.getProductsForTestGroup(this.testGroup);
        }
        if (StringUtils.isNotBlank((CharSequence)this.instanceId)) {
            Product product = this.getProductContexts().get(this.instanceId);
            if (product == null) {
                throw new MojoExecutionException("No product with instance ID '" + this.instanceId + "'");
            }
            return Collections.singletonList(product);
        }
        return Collections.singletonList(this.getProductContexts().get(this.getProductId()));
    }

    void validatePortConfiguration(List<Product> products) throws MojoExecutionException {
        HashMap portsById = new HashMap();
        MutableInt collisions = new MutableInt();
        products.stream().flatMap(AbstractTestGroupsHandlerMojo::getConfiguredPorts).filter(ConfiguredPort::isStatic).forEach(configured -> {
            ConfiguredPort conflict = (ConfiguredPort)portsById.get(((ConfiguredPort)configured).port);
            if (conflict == null) {
                portsById.put(((ConfiguredPort)configured).port, configured);
            } else {
                this.getLog().error((CharSequence)String.format(PORT_CONFLICT_MESSAGE_FORMAT, ((ConfiguredPort)configured).instanceId, ((ConfiguredPort)configured).nodeIndex, ((ConfiguredPort)configured).type, ((ConfiguredPort)configured).port, conflict.type, conflict.instanceId, conflict.nodeIndex));
                collisions.increment();
            }
        });
        int collisionCount = collisions.intValue();
        if (collisionCount != 0) {
            throw new MojoExecutionException(collisionCount + " port conflict" + (collisionCount == 1 ? " was" : "s were") + " detected between the " + products.size() + " products in the '" + this.testGroup + "' test group");
        }
    }

    private static Stream<ConfiguredPort> getConfiguredPorts(Product product) {
        String instanceId = product.getInstanceId();
        ArrayList<ConfiguredPort> configuredPorts = new ArrayList<ConfiguredPort>();
        List<Node> nodes = product.getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            configuredPorts.addAll(AbstractTestGroupsHandlerMojo.getConfiguredPorts(instanceId, node, i, product.getProtocol()));
        }
        return configuredPorts.stream();
    }

    private static Collection<ConfiguredPort> getConfiguredPorts(String instanceId, Node node, int nodeIndex, String protocol) {
        return Arrays.asList(new ConfiguredPort(instanceId, node.getWebPort(), protocol.toUpperCase(), nodeIndex), new ConfiguredPort(instanceId, node.getAjpPort(), "AJP", nodeIndex), new ConfiguredPort(instanceId, node.getRmiPort(), "RMI", nodeIndex));
    }

    @ParametersAreNonnullByDefault
    private static class ConfiguredPort {
        private final String instanceId;
        private final int port;
        private final String type;
        private final int nodeIndex;

        ConfiguredPort(String instanceId, int port, String type, int nodeIndex) {
            this.instanceId = Objects.requireNonNull(instanceId, "instanceId");
            this.port = port;
            this.type = Objects.requireNonNull(type, "type");
            this.nodeIndex = nodeIndex;
        }

        boolean isStatic() {
            return this.port != 0;
        }
    }
}

